/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.inventory.ItemKey;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.ClientHandler;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.GuiPotionCreator;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.forge.GuiContainerManager;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;

public class NEICPH
implements PacketCustom.IClientPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, bcw nethandler, atv mc) {
        switch (packet.getType()) {
            case 1: {
                this.handleSMPCheck(packet.readUByte(), packet.readString(), (abw)mc.f);
                break;
            }
            case 10: {
                this.handleLoginState(packet);
                break;
            }
            case 11: {
                this.handleActionDisabled(packet);
                break;
            }
            case 12: {
                this.handleActionEnabled(packet);
                break;
            }
            case 13: {
                ClientHandler.instance().addSMPMagneticItem(packet.readInt(), (abw)mc.f);
                break;
            }
            case 14: {
                this.handleGamemode(mc, packet.readUByte());
                break;
            }
            case 21: {
                ClientUtils.openSMPGui((int)packet.readUByte(), (awe)new GuiEnchantmentModifier(mc.h.bn, (abw)mc.f, 0, 0, 0));
                break;
            }
            case 23: {
                if (packet.readBoolean()) {
                    ClientUtils.openSMPGui((int)packet.readUByte(), (awe)new GuiExtendedCreativeInv(new ContainerCreativeInv((uf)mc.h, new ExtendedCreativeInv(null, Side.CLIENT))));
                    break;
                }
                mc.a((awe)new axv((uf)mc.h));
                break;
            }
            case 24: {
                ClientUtils.openSMPGui((int)packet.readUByte(), (awe)new GuiPotionCreator(mc.h.bn));
            }
        }
    }

    private void handleGamemode(atv mc, int mode) {
        mc.c.a(NEIServerUtils.getGameType(mode));
    }

    private void handleActionEnabled(PacketCustom packet) {
        String name = packet.readString();
        if (packet.readBoolean()) {
            NEIClientConfig.enabledActions.add(name);
        } else {
            NEIClientConfig.enabledActions.remove(name);
        }
    }

    private void handleActionDisabled(PacketCustom packet) {
        String name = packet.readString();
        if (packet.readBoolean()) {
            NEIClientConfig.disabledActions.add(name);
        } else {
            NEIClientConfig.disabledActions.remove(name);
        }
    }

    private void handleLoginState(PacketCustom packet) {
        int i;
        NEIClientConfig.permissableActions.clear();
        int num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.permissableActions.add(packet.readString());
        }
        NEIClientConfig.disabledActions.clear();
        num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.disabledActions.add(packet.readString());
        }
        NEIClientConfig.enabledActions.clear();
        num = packet.readUByte();
        for (i = 0; i < num; ++i) {
            NEIClientConfig.enabledActions.add(packet.readString());
        }
        num = packet.readInt();
        ArrayList<ItemKey> items = new ArrayList<ItemKey>(num);
        for (int i2 = 0; i2 < num; ++i2) {
            items.add(new ItemKey(packet.readUShort(), packet.readUShort()));
        }
        NEIClientConfig.setBannedBlocks(items);
        if (NEIClientUtils.getGuiContainer() != null) {
            LayoutManager.instance().refresh(NEIClientUtils.getGuiContainer());
        }
    }

    private void handleSMPCheck(int serverprotocol, String worldName, abw world) {
        if (serverprotocol > 0) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Client");
        } else if (serverprotocol < 0) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Server");
        } else {
            try {
                ClientHandler.instance().loadWorld(world, true);
                NEIClientConfig.loadWorld(NEICPH.getSaveName(worldName));
                NEIClientConfig.setHasSMPCounterPart(true);
                NEICPH.sendRequestLoginInfo();
            }
            catch (Exception nce) {
                nce.printStackTrace();
            }
        }
    }

    private static String getSaveName(String worldName) {
        if (ClientUtils.isLocal()) {
            return "local/" + ClientUtils.getWorldSaveName((String)worldName);
        }
        return "remote/" + ClientUtils.getServerIP().replace(':', '~') + "/" + worldName;
    }

    public static void sendSpawnItem(ye spawnstack, boolean infinite, boolean doSpawn) {
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeBoolean(infinite);
        packet.writeBoolean(doSpawn);
        List<String> name = GuiContainerManager.itemDisplayNameMultiline(spawnstack, null, false);
        packet.writeByte(name.size());
        for (String s : name) {
            packet.writeString(s);
        }
        packet.writeItemStack(spawnstack);
        packet.writeInt(spawnstack.b);
        packet.sendToServer();
    }

    public static void sendDeleteAllItems() {
        PacketCustom packet = new PacketCustom((Object)channel, 4);
        packet.sendToServer();
    }

    public static void sendStateLoad(ye[] state) {
        NEICPH.sendDeleteAllItems();
        for (int slot = 0; slot < state.length; ++slot) {
            ye item = state[slot];
            if (item == null) continue;
            NEICPH.sendSetSlot(slot, item, false);
        }
        PacketCustom packet = new PacketCustom((Object)channel, 11);
        packet.sendToServer();
    }

    public static void sendSetSlot(int slot, ye stack, boolean container) {
        PacketCustom packet = new PacketCustom((Object)channel, 5);
        packet.writeBoolean(container);
        packet.writeShort(slot);
        packet.writeItemStack(stack);
        packet.sendToServer();
    }

    private static void sendRequestLoginInfo() {
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        packet.sendToServer();
    }

    public static void sendToggleMagnetMode() {
        PacketCustom packet = new PacketCustom((Object)channel, 6);
        packet.sendToServer();
    }

    public static void sendSetTime(int hour) {
        PacketCustom packet = new PacketCustom((Object)channel, 7);
        packet.writeByte(hour);
        packet.sendToServer();
    }

    public static void sendHeal() {
        PacketCustom packet = new PacketCustom((Object)channel, 8);
        packet.sendToServer();
    }

    public static void sendToggleRain() {
        PacketCustom packet = new PacketCustom((Object)channel, 9);
        packet.sendToServer();
    }

    public static void sendOpenEnchantmentWindow() {
        PacketCustom packet = new PacketCustom((Object)channel, 21);
        packet.sendToServer();
    }

    public static void sendModifyEnchantment(int enchID, int level, boolean add) {
        PacketCustom packet = new PacketCustom((Object)channel, 22);
        packet.writeByte(enchID);
        packet.writeByte(level);
        packet.writeBoolean(add);
        packet.sendToServer();
    }

    public static void sendSetPropertyDisabled(String name, boolean enable) {
        PacketCustom packet = new PacketCustom((Object)channel, 12);
        packet.writeString(name);
        packet.writeBoolean(enable);
        packet.sendToServer();
    }

    public static void sendGamemode(int mode) {
        new PacketCustom((Object)channel, 13).writeByte(mode).sendToServer();
    }

    public static void sendCreativeInv(boolean open) {
        PacketCustom packet = new PacketCustom((Object)channel, 23);
        packet.writeBoolean(open);
        packet.sendToServer();
    }

    public static void sendCreativeScroll(int steps) {
        PacketCustom packet = new PacketCustom((Object)channel, 14);
        packet.writeInt(steps);
        packet.sendToServer();
    }

    public static void sendMobSpawnerID(int x, int y, int z, String mobtype) {
        PacketCustom packet = new PacketCustom((Object)channel, 15);
        packet.writeCoord(x, y, z);
        packet.writeString(mobtype);
        packet.sendToServer();
    }

    public static PacketCustom createContainerPacket() {
        return new PacketCustom((Object)channel, 20);
    }

    public static void sendOpenPotionWindow() {
        ye[] potionStore = new ye[9];
        InventoryUtils.readItemStacksFromTag((ye[])potionStore, (cg)NEIClientConfig.global.nbt.l("potionStore").m("items"));
        PacketCustom packet = new PacketCustom((Object)channel, 24);
        for (int i = 0; i < potionStore.length; ++i) {
            packet.writeItemStack(potionStore[i]);
        }
        packet.sendToServer();
    }

    public static void sendDummySlotSet(int slotNumber, ye stack) {
        PacketCustom packet = new PacketCustom((Object)channel, 25);
        packet.writeShort(slotNumber);
        packet.writeItemStack(stack, true);
        packet.sendToServer();
    }
}

