/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemBooze
extends ItemIC2 {
    public String[] solidRatio = new String[]{"Watery ", "Clear ", "Lite ", "", "Strong ", "Thick ", "Stodge ", "X"};
    public String[] hopsRatio = new String[]{"Soup ", "Alcfree ", "White ", "", "Dark ", "Full ", "Black ", "X"};
    public String[] timeRatioNames = new String[]{"Brew", "Youngster", "Beer", "Ale", "Dragonblood", "Black Stuff"};
    public int[] baseDuration = new int[]{300, 600, 900, 1200, 1600, 2000, 2400};
    public float[] baseIntensity = new float[]{0.4f, 0.75f, 1.0f, 1.5f, 2.0f};
    public static float rumStackability = 2.0f;
    public static int rumDuration = 600;

    public ItemBooze(Configuration config, InternalName internalName) {
        super(config, internalName);
        this.func_77625_d(1);
        this.func_77637_a(null);
    }

    @Override
    public String getTextureName(int index) {
        if (index < this.timeRatioNames.length) {
            return this.func_77658_a() + "." + InternalName.beer.name() + "." + this.timeRatioNames[index];
        }
        if (index == this.timeRatioNames.length) {
            return this.func_77658_a() + "." + InternalName.rum.name();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int meta) {
        int type = ItemBooze.getTypeOfValue(meta);
        if (type == 1) {
            int timeRatio = Math.min(ItemBooze.getTimeRatioOfBeerValue(meta), this.timeRatioNames.length - 1);
            return this.textures[timeRatio];
        }
        if (type == 2) {
            return this.textures[this.timeRatioNames.length];
        }
        return null;
    }

    @Override
    public String func_77628_j(ItemStack itemstack) {
        int meta = itemstack.func_77960_j();
        int type = ItemBooze.getTypeOfValue(meta);
        if (type == 1) {
            int timeRatio = Math.min(ItemBooze.getTimeRatioOfBeerValue(meta), this.timeRatioNames.length - 1);
            if (timeRatio == this.timeRatioNames.length - 1) {
                return this.timeRatioNames[timeRatio];
            }
            return this.solidRatio[ItemBooze.getSolidRatioOfBeerValue(meta)] + this.hopsRatio[ItemBooze.getHopsRatioOfBeerValue(meta)] + this.timeRatioNames[timeRatio];
        }
        if (type == 2) {
            return "Rum";
        }
        return "Zero";
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer player) {
        int meta = itemstack.func_77960_j();
        int type = ItemBooze.getTypeOfValue(meta);
        if (type == 0) {
            return new ItemStack(Ic2Items.mugEmpty.func_77973_b());
        }
        if (type == 1) {
            if (ItemBooze.getTimeRatioOfBeerValue(meta) == 5) {
                return this.drinkBlackStuff(player);
            }
            int solidRatio1 = ItemBooze.getSolidRatioOfBeerValue(meta);
            int alc = ItemBooze.getHopsRatioOfBeerValue(meta);
            int duration = this.baseDuration[solidRatio1];
            float intensity = this.baseIntensity[ItemBooze.getTimeRatioOfBeerValue(meta)];
            player.func_71024_bL().func_75122_a(6 - alc, (float)solidRatio1 * 0.15f);
            int max = (int)(intensity * ((float)alc * 0.5f));
            PotionEffect slow = player.func_70660_b(Potion.field_76419_f);
            int level = -1;
            if (slow != null) {
                level = slow.func_76458_c();
            }
            this.amplifyEffect(player, Potion.field_76419_f, max, intensity, duration);
            if (level > -1) {
                this.amplifyEffect(player, Potion.field_76420_g, max, intensity, duration);
                if (level > 0) {
                    this.amplifyEffect(player, Potion.field_76421_d, max / 2, intensity, duration);
                    if (level > 1) {
                        this.amplifyEffect(player, Potion.field_76429_m, max - 1, intensity, duration);
                        if (level > 2) {
                            this.amplifyEffect(player, Potion.field_76431_k, 0, intensity, duration);
                            if (level > 3) {
                                player.func_70690_d(new PotionEffect(Potion.field_76433_i.field_76415_H, 1, player.field_70170_p.field_73012_v.nextInt(3)));
                            }
                        }
                    }
                }
            }
        }
        if (type == 2) {
            if (ItemBooze.getProgressOfRumValue(meta) < 100) {
                this.drinkBlackStuff(player);
            } else {
                this.amplifyEffect(player, Potion.field_76426_n, 0, rumStackability, rumDuration);
                PotionEffect def = player.func_70660_b(Potion.field_76429_m);
                int level = -1;
                if (def != null) {
                    level = def.func_76458_c();
                }
                this.amplifyEffect(player, Potion.field_76429_m, 2, rumStackability, rumDuration);
                if (level >= 0) {
                    this.amplifyEffect(player, Potion.field_76440_q, 0, rumStackability, rumDuration);
                }
                if (level >= 1) {
                    this.amplifyEffect(player, Potion.field_76431_k, 0, rumStackability, rumDuration);
                }
            }
        }
        return new ItemStack(Ic2Items.mugEmpty.func_77973_b());
    }

    public void amplifyEffect(EntityPlayer player, Potion potion1, int max, float intensity, int duration) {
        PotionEffect eff = player.func_70660_b(potion1);
        if (eff == null) {
            player.func_70690_d(new PotionEffect(potion1.field_76415_H, duration, 0));
        } else {
            int newdur = eff.func_76459_b();
            int maxnewdur = (int)((float)duration * (1.0f + intensity * 2.0f) - (float)newdur) / 2;
            if (maxnewdur < 0) {
                maxnewdur = 0;
            }
            if (maxnewdur < duration) {
                duration = maxnewdur;
            }
            newdur += duration;
            int newamp = eff.func_76458_c();
            if (newamp < max) {
                ++newamp;
            }
            player.func_70690_d(new PotionEffect(potion1.field_76415_H, newdur, newamp));
        }
    }

    public ItemStack drinkBlackStuff(EntityPlayer player) {
        switch (player.field_70170_p.field_73012_v.nextInt(6)) {
            case 1: {
                player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 1200, 0));
                break;
            }
            case 2: {
                player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 2400, 0));
                break;
            }
            case 3: {
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 2400, 0));
                break;
            }
            case 4: {
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 2));
                break;
            }
            case 5: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.field_76415_H, 1, player.field_70170_p.field_73012_v.nextInt(4)));
            }
        }
        return new ItemStack(Ic2Items.mugEmpty.func_77973_b());
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        player.func_71008_a(itemstack, this.func_77626_a(itemstack));
        return itemstack;
    }

    public static int getTypeOfValue(int value) {
        return ItemBooze.skipGetOfValue(value, 0, 2);
    }

    public static int getAmountOfValue(int value) {
        if (ItemBooze.getTypeOfValue(value) == 0) {
            return 0;
        }
        return ItemBooze.skipGetOfValue(value, 2, 5) + 1;
    }

    public static int getSolidRatioOfBeerValue(int value) {
        return ItemBooze.skipGetOfValue(value, 7, 3);
    }

    public static int getHopsRatioOfBeerValue(int value) {
        return ItemBooze.skipGetOfValue(value, 10, 3);
    }

    public static int getTimeRatioOfBeerValue(int value) {
        return ItemBooze.skipGetOfValue(value, 13, 3);
    }

    public static int getProgressOfRumValue(int value) {
        return ItemBooze.skipGetOfValue(value, 7, 7);
    }

    private static int skipGetOfValue(int value, int bitshift, int take) {
        take = (int)Math.pow(2.0, take) - 1;
        return (value >>= bitshift) & take;
    }
}

