/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.BaseElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;

public class ItemBattery
extends BaseElectricItem {
    public ItemBattery(Configuration config, InternalName internalName, int maxCharge1, int transferLimit1, int tier1) {
        super(config, internalName);
        this.setNoRepair();
        this.maxCharge = maxCharge1;
        this.transferLimit = transferLimit1;
        this.tier = tier1;
    }

    @Override
    public String getTextureName(int index) {
        if (index < 5) {
            return this.func_77658_a().substring(4) + "." + index;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int meta) {
        if (meta <= 1) {
            return this.textures[4];
        }
        if (meta >= this.func_77612_l() - 1) {
            return this.textures[0];
        }
        return this.textures[3 - 3 * (meta - 2) / (this.func_77612_l() - 4 + 1)];
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getEmptyItemId(ItemStack itemStack) {
        if (this.field_77779_bT == Ic2Items.chargedReBattery.field_77993_c) {
            return Ic2Items.reBattery.field_77993_c;
        }
        return super.getEmptyItemId(itemStack);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && itemStack.field_77993_c == Ic2Items.chargedReBattery.field_77993_c) {
            boolean transferred = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = entityplayer.field_71071_by.field_70462_a[i];
                if (stack == null || !(Item.field_77698_e[stack.field_77993_c] instanceof IElectricItem) || Item.field_77698_e[stack.field_77993_c] instanceof ItemBattery) continue;
                IElectricItem item = (IElectricItem)stack.func_77973_b();
                int transfer = ElectricItem.manager.discharge(itemStack, 2 * this.transferLimit, item.getTier(stack), true, true);
                transfer = ElectricItem.manager.charge(stack, transfer, this.tier, true, false);
                ElectricItem.manager.discharge(itemStack, transfer, item.getTier(stack), true, false);
                if (transfer <= 0) continue;
                transferred = true;
            }
            if (transferred && !IC2.platform.isRendering()) {
                entityplayer.field_71070_bA.func_75142_b();
            }
        }
        return itemStack;
    }
}

