/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.command;

import ic2.core.IC2;
import ic2.core.util.Config;
import ic2.core.util.DropScan;
import ic2.core.util.ItemStackWrapper;
import ic2.core.util.PriorityExecutor;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableLong;

public class CommandScan
extends CommandBase {
    public String func_71517_b() {
        return "scan";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/scan";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        EntityPlayerMP player = CommandScan.func_71521_c((ICommandSender)sender);
        int area = 50000;
        int areaCount = 4096;
        int range = 5;
        FutureTask[] futures = new FutureTask[areaCount];
        for (int i = 0; i < areaCount; ++i) {
            int x = IC2.random.nextInt(area) - area / 2;
            int z = IC2.random.nextInt(area) - area / 2;
            futures[i] = IC2.getInstance().threadPool.submit(new Calculation(player.field_70170_p, x, z, range));
        }
        this.analyze(futures);
    }

    public int compareTo(Object o) {
        return super.func_71525_a((ICommand)o);
    }

    public void analyze(Future<Iterable<Map.Entry<ItemStack, Integer>>>[] futures) {
        HashMap<ItemStackWrapper, MutableLong> result = new HashMap<ItemStackWrapper, MutableLong>();
        for (Future<Iterable<Map.Entry<ItemStack, Integer>>> future : futures) {
            try {
                Iterable<Map.Entry<ItemStack, Integer>> partialResult = future.get();
                for (Map.Entry<ItemStack, Integer> entry : partialResult) {
                    ItemStackWrapper key = new ItemStackWrapper(entry.getKey());
                    MutableLong amount = (MutableLong)result.get(key);
                    if (amount == null) {
                        amount = new MutableLong();
                        result.put(key, amount);
                    }
                    amount.add((Number)entry.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        TreeSet<Map.Entry<ItemStackWrapper, MutableLong>> counts = new TreeSet<Map.Entry<ItemStackWrapper, MutableLong>>(new Comparator<Map.Entry<ItemStackWrapper, MutableLong>>(){

            @Override
            public int compare(Map.Entry<ItemStackWrapper, MutableLong> a, Map.Entry<ItemStackWrapper, MutableLong> b) {
                long ret = b.getValue().getValue() - a.getValue().getValue();
                return ret > 0L ? 1 : (ret < 0L ? -1 : 0);
            }
        });
        counts.addAll(result.entrySet());
        IC2.log.info("total");
        Config config = new Config("uu values");
        double cobbleValue = ((MutableLong)result.get(new ItemStackWrapper(new ItemStack(Block.field_71978_w)))).getValue().longValue();
        for (Map.Entry entry : counts) {
            ItemStack stack = ((ItemStackWrapper)entry.getKey()).stack;
            IC2.log.info(((MutableLong)entry.getValue()).getValue() + " " + stack);
            Config.Value value = new Config.Value(stack.field_77993_c + "-" + stack.func_77960_j(), stack.func_77973_b().func_77667_c(stack), Double.toString(cobbleValue / (double)((MutableLong)entry.getValue()).getValue().longValue()));
            config.set(value.name, value);
        }
        try {
            config.save(new File("uu_values.ini"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static class Calculation
    implements Callable<Iterable<Map.Entry<ItemStack, Integer>>>,
    PriorityExecutor.CustomPriority {
        private final World world;
        private final int x;
        private final int z;
        private final int range;

        Calculation(World world1, int x1, int z1, int range1) {
            this.world = world1;
            this.x = x1;
            this.z = z1;
            this.range = range1;
        }

        @Override
        public Iterable<Map.Entry<ItemStack, Integer>> call() throws Exception {
            System.out.println(((ThreadPoolExecutor)IC2.getInstance().threadPool).getQueue().size() + " tasks queued");
            return new DropScan().scanArea(this.world, this.x, this.z, this.range);
        }

        @Override
        public int getPriority() {
            return -100;
        }
    }
}

