/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.tile.IWrenchable;
import ic2.core.ExplosionIC2;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.wiring.TileEntityCable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityLuminator
extends TileEntity
implements IEnergySink,
IWrenchable {
    public double energy = 0.0;
    public boolean lswitch = true;
    public int ticker = -1;
    public boolean ignoreBlockStay = false;
    public int maxInput = 32;
    public boolean addedToEnergyNet = false;
    private boolean loaded = false;

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74765_d("energy");
        }
        this.lswitch = nbttagcompound.func_74767_n("lswitch");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74757_a("lswitch", this.lswitch);
    }

    public void func_70312_q() {
        super.func_70312_q();
        IC2.addSingleTickCallback(this.field_70331_k, new ITickCallback(){

            @Override
            public void tickCallback(World world) {
                if (TileEntityLuminator.this.func_70320_p() || !world.func_72899_e(TileEntityLuminator.this.field_70329_l, TileEntityLuminator.this.field_70330_m, TileEntityLuminator.this.field_70327_n)) {
                    return;
                }
                TileEntityLuminator.this.onLoaded();
                if (TileEntityLuminator.this.enableUpdateEntity()) {
                    world.field_73009_h.add(TileEntityLuminator.this);
                }
            }
        });
    }

    public void func_70313_j() {
        super.func_70313_j();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.loaded) {
            this.onUnloaded();
        }
    }

    public void onLoaded() {
        if (IC2.platform.isSimulating() && !this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public final boolean canUpdate() {
        return false;
    }

    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public boolean isRedstonePowered() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70316_g() {
        ++this.ticker;
        if (this.ticker % 4 == 0) {
            TileEntityLuminator newLumi;
            if (this.isActive()) {
                this.energy -= 1.0;
            }
            if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n) == Ic2Items.activeLuminator.field_77993_c && !this.isActive()) {
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.luminator.field_77993_c, this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n), 7);
                newLumi = (TileEntityLuminator)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                newLumi.lswitch = this.lswitch;
                newLumi.energy = this.energy;
            }
            if (this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n) == Ic2Items.luminator.field_77993_c && this.isActive()) {
                this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, Ic2Items.activeLuminator.field_77993_c, this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n), 7);
                newLumi = (TileEntityLuminator)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                newLumi.lswitch = this.lswitch;
                newLumi.energy = this.energy;
            }
        }
    }

    public boolean isActive() {
        if (this.energy <= 0.0) {
            return false;
        }
        return !this.lswitch && this.isRedstonePowered() || this.lswitch && !this.isRedstonePowered();
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return emitter instanceof TileEntityCable;
    }

    @Override
    public double demandedEnergyUnits() {
        return (double)this.getMaxEnergy() - this.energy;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (amount > (double)this.maxInput) {
            this.poof();
            return 0.0;
        }
        if (this.energy >= (double)this.getMaxEnergy() || amount <= 0.0) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return this.maxInput;
    }

    public int getMaxEnergy() {
        return 2;
    }

    public void poof() {
        if (this.loaded) {
            this.onUnloaded();
        }
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 7);
        ExplosionIC2 explosion = new ExplosionIC2(this.field_70331_k, null, 0.5 + (double)this.field_70329_l, 0.5 + (double)this.field_70330_m, 0.5 + (double)this.field_70327_n, 0.5f, 0.85f);
        explosion.doExplosion();
    }

    public boolean canCableConnectFrom(int x, int y, int z) {
        int facing = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        switch (facing) {
            case 0: {
                return x == this.field_70329_l && y == this.field_70330_m + 1 && z == this.field_70327_n;
            }
            case 1: {
                return x == this.field_70329_l && y == this.field_70330_m - 1 && z == this.field_70327_n;
            }
            case 2: {
                return x == this.field_70329_l && y == this.field_70330_m && z == this.field_70327_n + 1;
            }
            case 3: {
                return x == this.field_70329_l && y == this.field_70330_m && z == this.field_70327_n - 1;
            }
            case 4: {
                return x == this.field_70329_l + 1 && y == this.field_70330_m && z == this.field_70327_n;
            }
            case 5: {
                return x == this.field_70329_l - 1 && y == this.field_70330_m && z == this.field_70327_n;
            }
        }
        return false;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return true;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
        this.lswitch = !this.lswitch;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }
}

