/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.IListRecipeManager;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.BasicListRecipeManager;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotProcessableGeneric;
import ic2.core.block.machine.ContainerStandardMachine;
import ic2.core.block.machine.gui.GuiRecycler;
import ic2.core.block.machine.tileentity.TileEntityStandardMachine;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class TileEntityRecycler
extends TileEntityStandardMachine {
    public TileEntityRecycler() {
        super(1, 45, 1);
        this.inputSlot = new InvSlotProcessableGeneric((TileEntityInventory)this, "input", 0, 1, Recipes.recycler);
    }

    public static void init(Configuration config) {
        Recipes.recycler = new RecyclerRecipeManager();
        Recipes.recyclerWhitelist = new BasicListRecipeManager();
        Recipes.recyclerBlacklist = new BasicListRecipeManager();
        Recipes.recyclerBlacklist.add(new ItemStack(Block.field_72003_bq));
        Recipes.recyclerBlacklist.add(new ItemStack(Item.field_77669_D));
        Recipes.recyclerBlacklist.add(new ItemStack(Item.field_77768_aD));
        Recipes.recyclerBlacklist.add(new ItemStack(Block.field_72037_aS));
        Recipes.recyclerBlacklist.add(new ItemStack(Block.field_72039_aU));
        Recipes.recyclerBlacklist.add(Ic2Items.scaffold);
        if (config != null) {
            Property prop = config.get("general", "recyclerBlacklist", TileEntityRecycler.getRecyclerBlacklistString());
            prop.comment = "List of blocks and items which should not be turned into scrap by the recycler. Comma separated, format is id-metadata";
            TileEntityRecycler.setListFromString(prop.getString(), Recipes.recyclerBlacklist);
            prop = config.get("general", "recyclerWhitelist", "");
            prop.comment = "List of blocks and items which are only allowed to be turned into scrap by the recycler, Overrides Blacklist if not left empty. Comma separated, format is id-metadata";
            TileEntityRecycler.setListFromString(prop.getString(), Recipes.recyclerWhitelist);
        }
    }

    @Override
    public String func_70303_b() {
        return "Recycler";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiRecycler(new ContainerStandardMachine(entityPlayer, this));
    }

    public static int recycleChance() {
        return 8;
    }

    @Override
    public String getStartSoundFile() {
        return "Machines/RecyclerOp.ogg";
    }

    @Override
    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public float getWrenchDropRate() {
        return 0.85f;
    }

    public static boolean getIsItemBlacklisted(ItemStack aStack) {
        if (Recipes.recyclerWhitelist.isEmpty()) {
            return Recipes.recyclerBlacklist.contains(aStack);
        }
        return !Recipes.recyclerWhitelist.contains(aStack);
    }

    @Override
    public void operateOnce(RecipeOutput output, List<ItemStack> processResult) {
        this.inputSlot.consume();
        if (IC2.random.nextInt(TileEntityRecycler.recycleChance()) == 0) {
            this.outputSlot.add(processResult);
        }
    }

    private static String getRecyclerBlacklistString() {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (ItemStack entry : Recipes.recyclerBlacklist) {
            if (entry == null) continue;
            if (first) {
                first = false;
            } else {
                ret.append(", ");
            }
            ret.append(entry.field_77993_c);
            if (entry.func_77960_j() == 0) continue;
            ret.append("-");
            ret.append(entry.func_77960_j());
        }
        return ret.toString();
    }

    private static void setListFromString(String str, IListRecipeManager aList) {
        String[] strParts;
        for (String strPart : strParts = str.trim().split("\\s*,\\s*")) {
            String[] idMeta = strPart.split("\\s*-\\s*");
            if (idMeta[0].length() == 0) continue;
            int blockId = Integer.parseInt(idMeta[0]);
            int metaData = Short.MAX_VALUE;
            if (idMeta.length == 2) {
                metaData = Integer.parseInt(idMeta[1]);
            }
            ItemStack is = new ItemStack(blockId, 1, metaData);
            aList.add(is);
        }
    }

    private static class RecyclerRecipeManager
    implements IMachineRecipeManager {
        @Override
        public void addRecipe(IRecipeInput input, NBTTagCompound metadata, ItemStack ... outputs) {
        }

        @Override
        public RecipeOutput getOutputFor(ItemStack input, boolean adjustInput) {
            RecipeOutput ret = !TileEntityRecycler.getIsItemBlacklisted(input) ? new RecipeOutput(null, Ic2Items.scrap) : new RecipeOutput(null, new ItemStack[0]);
            if (adjustInput) {
                --input.field_77994_a;
            }
            return ret;
        }

        @Override
        public Map<IRecipeInput, RecipeOutput> getRecipes() {
            return null;
        }
    }
}

