/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;

public class CropRedWheat
extends CropCard {
    @Override
    public String name() {
        return "Redwheat";
    }

    @Override
    public String discoveredBy() {
        return "raa1337";
    }

    @Override
    public int tier() {
        return 6;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String[] attributes() {
        return new String[]{"Red", "Redstone", "Wheat"};
    }

    @Override
    public int maxSize() {
        return 7;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < 7 && crop.getLightLevel() <= 10 && crop.getLightLevel() >= 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 7;
    }

    @Override
    public float dropGainChance() {
        return 0.5f;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        ChunkCoordinates coords = crop.getLocation();
        if (crop.getWorld().func_72864_z(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) || crop.getWorld().field_73012_v.nextBoolean()) {
            return new ItemStack(Item.field_77767_aC, 1);
        }
        return new ItemStack(Item.field_77685_T, 1);
    }

    @Override
    public int emitRedstone(ICropTile crop) {
        return crop.getSize() == 7 ? 15 : 0;
    }

    @Override
    public int getEmittedLight(ICropTile crop) {
        return crop.getSize() == 7 ? 7 : 0;
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return 600;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }
}

