/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block;

import ic2.core.IC2;
import ic2.core.Ic2Items;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class WorldGenRubTree
extends WorldGenerator {
    public static final int maxHeight = 8;

    public boolean func_76484_a(World world, Random random, int x, int count, int z) {
        while (count > 0) {
            int y;
            for (y = IC2.getWorldHeight(world) - 1; world.func_72799_c(x, y - 1, z) && y > 0; --y) {
            }
            if (!this.grow(world, x, y, z, random)) {
                count -= 3;
            }
            x += random.nextInt(15) - 7;
            z += random.nextInt(15) - 7;
            --count;
        }
        return true;
    }

    public boolean grow(World world, int x, int y, int z, Random random) {
        if (world == null || Ic2Items.rubberWood == null) {
            IC2.log.warning("Had a null that shouldn't have been. RubberTree did not spawn! w=" + world + " r=" + Ic2Items.rubberWood);
            return false;
        }
        int treeholechance = 25;
        int height = this.getGrowHeight(world, x, y, z);
        if (height < 2) {
            return false;
        }
        height -= random.nextInt(height / 2 + 1);
        for (int cHeight = 0; cHeight < height; ++cHeight) {
            world.func_72832_d(x, y + cHeight, z, Ic2Items.rubberWood.field_77993_c, 0, 3);
            if (random.nextInt(100) <= treeholechance) {
                treeholechance -= 10;
                world.func_72921_c(x, y + cHeight, z, random.nextInt(4) + 2, 3);
            } else {
                world.func_72921_c(x, y + cHeight, z, 1, 3);
            }
            if (height >= 4 && (height >= 7 || cHeight <= 1) && cHeight <= 2) continue;
            for (int cx = x - 2; cx <= x + 2; ++cx) {
                for (int cz = z - 2; cz <= z + 2; ++cz) {
                    boolean gen;
                    int c = Math.max(1, cHeight + 4 - height);
                    boolean bl = gen = cx > x - 2 && cx < x + 2 && cz > z - 2 && cz < z + 2 || cx > x - 2 && cx < x + 2 && random.nextInt(c) == 0 || cz > z - 2 && cz < z + 2 && random.nextInt(c) == 0;
                    if (!gen || !world.func_72799_c(cx, y + cHeight, cz)) continue;
                    world.func_72832_d(cx, y + cHeight, cz, Ic2Items.rubberLeaves.field_77993_c, 0, 3);
                }
            }
        }
        for (int i = 0; i <= height / 4 + random.nextInt(2); ++i) {
            if (!world.func_72799_c(x, y + height + i, z)) continue;
            world.func_72832_d(x, y + height + i, z, Ic2Items.rubberLeaves.field_77993_c, 0, 3);
        }
        return true;
    }

    public int getGrowHeight(World world, int x, int y, int z) {
        int height;
        int id = world.func_72798_a(x, y - 1, z);
        if (Block.field_71973_m[id] == null || !Block.field_71973_m[id].canSustainPlant(world, x, y - 1, z, ForgeDirection.UP, (IPlantable)Block.field_71973_m[Ic2Items.rubberSapling.field_77993_c]) || !world.func_72799_c(x, y, z) && world.func_72798_a(x, y, z) != Ic2Items.rubberSapling.field_77993_c) {
            return 0;
        }
        for (height = 1; world.func_72799_c(x, y + 1, z) && height < 8; ++height) {
            ++y;
        }
        return height;
    }
}

