/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TFacePart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.minecraft.McMetaPart;
import net.minecraftforge.common.ForgeDirection;

public abstract class McSidedMetaPart
extends McMetaPart
implements TFacePart {
    public McSidedMetaPart() {
    }

    public McSidedMetaPart(int meta) {
        super(meta);
    }

    public abstract int sideForMeta(int var1);

    @Override
    public void onNeighborChanged() {
        if (!this.world().I) {
            this.dropIfCantStay();
        }
    }

    public boolean canStay() {
        BlockCoord pos = new BlockCoord((asp)this.tile()).offset(this.sideForMeta(this.meta));
        return this.world().isBlockSolidOnSide(pos.x, pos.y, pos.z, ForgeDirection.getOrientation((int)(this.sideForMeta(this.meta) ^ 1)));
    }

    public boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        TileMultipart.dropItem(new ye(this.getBlock()), this.world(), Vector3.fromTileEntityCenter((asp)this.tile()));
        this.tile().remPart(this);
    }

    @Override
    public int getSlotMask() {
        return 1 << this.sideForMeta(this.meta);
    }

    @Override
    public boolean solid(int side) {
        return false;
    }

    @Override
    public int redstoneConductionMap() {
        return 31;
    }
}

