/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.compatibility.computercraft;

import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.ASMReader;
import codechicken.lib.asm.ClassHeirachyManager;
import codechicken.lib.asm.InstructionComparator;
import codechicken.lib.asm.ObfMapping;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TransformerComputerCraft
implements IClassTransformer,
Opcodes {
    private static LaunchClassLoader cl = (LaunchClassLoader)ClassHeirachyManager.class.getClassLoader();
    private TreeMap<String, IClassPatcher> patches = new TreeMap();
    private Map<String, ASMReader.ASMBlock> asmBlocks;

    private static byte[] getBytes(String string) {
        try {
            return cl.getClassBytes(string.replace('/', '.'));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private ASMReader.ASMBlock getASMBlock(String string) {
        if (this.asmBlocks == null) {
            this.asmBlocks = ASMReader.loadResource((String)"/assets/projectred/asm/computercraft.asm");
        }
        return this.asmBlocks.get(string);
    }

    public TransformerComputerCraft() {
        this.patches.put("dan200.computer.shared.RedPowerTileEntityComputer", new ClassReplacer("mrtjp.projectred.compatibility.computercraft.ProjectRedTileEntityComputer"));
        this.patches.put("dan200.turtle.shared.RedPowerTileEntityTurtle", new ClassReplacer("mrtjp.projectred.compatibility.computercraft.ProjectRedTileEntityTurtle"));
        this.patches.put("dan200.computer.shared.RedPowerInterop", new IClassPatcher(){
            Map<String, String> remappings = new ImmutableMap.Builder().put((Object)"com.eloraam.redpower.core.RedPowerLib", (Object)"mrtjp.projectred.ProjectRedCore").put((Object)"com.eloraam.redpower.RedPowerWorld", (Object)"mrtjp.projectred.ProjectRedExploration").put((Object)"itemPickaxeRuby", (Object)"itemRubyPickaxe").put((Object)"itemPickaxeGreenSapphire", (Object)"itemPeridotPickaxe").put((Object)"itemPickaxeSapphire", (Object)"itemSapphirePickaxe").put((Object)"itemShovelRuby", (Object)"itemRubyShovel").put((Object)"itemShovelGreenSapphire", (Object)"itemPeridotShovel").put((Object)"itemShovelSapphire", (Object)"itemSapphireShovel").put((Object)"itemAxeRuby", (Object)"itemRubyAxe").put((Object)"itemAxeGreenSapphire", (Object)"itemPeridotAxe").put((Object)"itemAxeSapphire", (Object)"itemSapphireAxe").put((Object)"itemSwordRuby", (Object)"itemRubySword").put((Object)"itemSwordGreenSapphire", (Object)"itemPeridotSword").put((Object)"itemSwordSapphire", (Object)"itemSapphireSword").put((Object)"itemHoeRuby", (Object)"itemRubyHoe").put((Object)"itemHoeGreenSapphire", (Object)"itemPeridotHoe").put((Object)"itemHoeSapphire", (Object)"itemSapphireHoe").build();

            @Override
            public byte[] apply(String string, byte[] byArray) {
                ClassNode classNode = ASMHelper.createClassNode((byte[])byArray);
                this.remapMethod(ASMHelper.findMethod((ObfMapping)new ObfMapping("dan200/computer/shared/RedPowerInterop", "findRedPower", "()V"), (ClassNode)classNode));
                this.remapMethod(ASMHelper.findMethod((ObfMapping)new ObfMapping("dan200/computer/shared/RedPowerInterop", "findRedPowerWorld", "()V"), (ClassNode)classNode));
                return ASMHelper.createBytes((ClassNode)classNode, (int)0);
            }

            private void remapMethod(MethodNode methodNode) {
                for (AbstractInsnNode abstractInsnNode = methodNode.instructions.getFirst(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
                    if (!(abstractInsnNode instanceof LdcInsnNode)) continue;
                    LdcInsnNode ldcInsnNode = (LdcInsnNode)abstractInsnNode;
                    if (!(ldcInsnNode.cst instanceof String) || !this.remappings.containsKey(ldcInsnNode.cst)) continue;
                    ldcInsnNode.cst = this.remappings.get(ldcInsnNode.cst);
                }
            }
        });
        this.patches.put("dan200.computer.shared.BlockComputerBase", new IClassPatcher(){

            @Override
            public byte[] apply(String string, byte[] byArray) {
                ClassNode classNode = ASMHelper.createClassNode((byte[])byArray);
                for (MethodNode methodNode : classNode.methods) {
                    if (!methodNode.name.equals("getBundledPowerOutput")) continue;
                    methodNode.instructions = ((TransformerComputerCraft)TransformerComputerCraft.this).getASMBlock((String)"getBundledPowerOutput").insns;
                }
                return ASMHelper.createBytes((ClassNode)classNode, (int)3);
            }
        });
        this.patches.put("dan200.computer.shared.NetworkedComputerHelper", new IClassPatcher(){

            @Override
            public byte[] apply(String string, byte[] byArray) {
                ClassNode classNode = ASMHelper.createClassNode((byte[])byArray);
                for (MethodNode methodNode : classNode.methods) {
                    AbstractInsnNode abstractInsnNode;
                    InsnList insnList;
                    if (methodNode.name.equals("updateRedstone")) {
                        insnList = new InsnList();
                        insnList.add(ObfMapping.fromDesc((String)"dan200/computer/shared/MFRInterop.isMFRInstalled()Z").toInsn(184));
                        abstractInsnNode = (AbstractInsnNode)InstructionComparator.insnListFindStart((InsnList)methodNode.instructions, (InsnList)insnList).get(0);
                        ASMHelper.removeBlock((InsnList)methodNode.instructions, (InstructionComparator.InsnListSection)new InstructionComparator.InsnListSection(abstractInsnNode, abstractInsnNode.getNext()));
                        InsnList insnList2 = new InsnList();
                        insnList2.add(ObfMapping.fromDesc((String)"dan200/computer/shared/BlockComputerBase.updateCable(Lnet/minecraft/world/World;III)V").toInsn(182));
                        AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)InstructionComparator.insnListFindStart((InsnList)methodNode.instructions, (InsnList)insnList2).get(0);
                        methodNode.instructions.insert(abstractInsnNode2, ((TransformerComputerCraft)TransformerComputerCraft.this).getASMBlock((String)"cableUpdate").insns);
                        continue;
                    }
                    if (!methodNode.name.equals("update")) continue;
                    insnList = new InsnList();
                    insnList.add(ObfMapping.fromDesc((String)"dan200/computer/shared/NetworkedComputerHelper.m_firstFrame:Z").toInsn(180));
                    abstractInsnNode = ((AbstractInsnNode)InstructionComparator.insnListFindStart((InsnList)methodNode.instructions, (InsnList)insnList).get(0)).getNext();
                    methodNode.instructions.insert(abstractInsnNode, ((TransformerComputerCraft)TransformerComputerCraft.this).getASMBlock((String)"firstFrame").insns);
                }
                return ASMHelper.createBytes((ClassNode)classNode, (int)3);
            }
        });
    }

    public byte[] transform(String string, String string2, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        IClassPatcher iClassPatcher = this.patches.get(string);
        if (iClassPatcher != null) {
            try {
                byArray = iClassPatcher.apply(string, byArray);
            }
            catch (Exception exception) {
                System.err.println("Failed to apply ProjectRed integration to ComputerCraft class: " + string + "\n please ensure you have ComputerCraft 1.58 installed");
                exception.printStackTrace();
            }
        }
        return byArray;
    }

    private class ClassReplacer
    implements IClassPatcher {
        private String replacement;

        public ClassReplacer(String string) {
            this.replacement = string;
        }

        @Override
        public byte[] apply(String string, byte[] byArray) {
            ClassReader classReader = new ClassReader(TransformerComputerCraft.getBytes(this.replacement));
            ClassWriter classWriter = new ClassWriter(0);
            RemappingClassAdapter remappingClassAdapter = new RemappingClassAdapter((ClassVisitor)classWriter, (Remapper)new SimpleRemapper(this.replacement.replace('.', '/'), string.replace('.', '/')));
            classReader.accept((ClassVisitor)remappingClassAdapter, 8);
            return classWriter.toByteArray();
        }
    }

    private static interface IClassPatcher {
        public byte[] apply(String var1, byte[] var2);
    }
}

