/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import java.io.FileNotFoundException;
import java.io.PrintStream;

public class GenerateInverseFromMinor {
    String className = "UnrolledInverseFromMinor";
    PrintStream stream = new PrintStream(this.className + ".java");
    int N;

    public void createClass(int n) {
        this.printTop(n);
        this.printCalls(n);
        for (int i = 2; i <= n; ++i) {
            this.printFunction(i);
        }
        this.stream.print("}\n");
    }

    private void printTop(int n) {
        String string = "/*\n * Copyright (c) 2009-2010, Peter Abeles. All Rights Reserved.\n *\n * This file is part of Efficient Java Matrix Library (EJML).\n *\n * EJML is free software: you can redistribute it and/or modify\n * it under the terms of the GNU Lesser General Public License as\n * published by the Free Software Foundation, either version 3\n * of the License, or (at your option) any later version.\n *\n * EJML is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n * GNU Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with EJML.  If not, see <http://www.gnu.org/licenses/>.\n */\n\npackage org.ejml.alg.dense.misc;\n\nimport org.ejml.data.DenseMatrix64F;\n\n\n/**\n * This code was auto generated by  {@link GenerateInverseFromMinor} and should not be modified\n * directly.  The input matrix is scaled make it much less prone to overflow and underflow issues.\n * \n * @author Peter Abeles\n */\npublic class " + this.className + " {\n" + "    \n" + "    public static final int MAX = " + n + ";\n";
        this.stream.print(string);
    }

    private void printCalls(int n) {
        this.stream.print("    \n    public static void inv( DenseMatrix64F mat , DenseMatrix64F inv ) {\n");
        this.stream.print("        double max = Math.abs(mat.data[0]);\n        int N = mat.getNumElements();\n        \n        for( int i = 1; i < N; i++ ) {\n            double a = Math.abs(mat.data[i]);\n            if( a > max ) max = a;\n        }\n\n");
        this.stream.print("        if( mat.numRows == 2 ) {\n            inv2(mat,inv,1.0/max);\n");
        for (int i = 3; i <= n; ++i) {
            this.stream.print("        } else if( mat.numRows == " + i + " ) {\n" + "            inv" + i + "(mat,inv,1.0/max);            \n");
        }
        this.stream.print("        } else {\n            throw new IllegalArgumentException(\"Not supported\");\n        }\n    }\n\n");
    }

    private void printFunction(int n) {
        int n2;
        int n3;
        this.stream.print("    public static void inv" + n + "( DenseMatrix64F mat , DenseMatrix64F inv , double scale )\n" + "    {\n" + "        double []data = mat.data;\n" + "\n");
        this.N = n;
        int[] nArray = new int[n * n];
        int n4 = 0;
        for (n3 = 1; n3 <= n; ++n3) {
            n2 = 1;
            while (n2 <= n) {
                nArray[n4] = n4;
                this.stream.print("        double " + this.a(n4) + " = data[ " + n4 + " ]*scale;\n");
                ++n2;
                ++n4;
            }
        }
        this.stream.println();
        n4 = 0;
        for (n3 = 1; n3 <= n; ++n3) {
            n2 = 1;
            while (n2 <= n) {
                this.stream.print("        double m" + n3 + "" + n2 + " = ");
                if ((n3 + n2) % 2 == 1) {
                    this.stream.print("-( ");
                }
                this.printTopMinor(nArray, n3 - 1, n2 - 1, n);
                if ((n3 + n2) % 2 == 1) {
                    this.stream.print(")");
                }
                this.stream.print(";\n");
                ++n2;
                ++n4;
            }
        }
        this.stream.println();
        this.stream.print("        double det = (a11*m11");
        for (n3 = 2; n3 <= n; ++n3) {
            this.stream.print(" + " + this.a(n3 - 1) + "*m" + 1 + "" + n3);
        }
        this.stream.println(")/scale;");
        this.stream.println();
        this.stream.print("        data = inv.data;\n");
        n4 = 0;
        for (n3 = 1; n3 <= n; ++n3) {
            n2 = 1;
            while (n2 <= n) {
                this.stream.print("        data[" + n4 + "] = m" + n2 + "" + n3 + " / det;\n");
                ++n2;
                ++n4;
            }
        }
        this.stream.println();
        this.stream.print("    }\n");
        this.stream.print("\n");
    }

    private void printTopMinor(int[] nArray, int n, int n2, int n3) {
        int[] nArray2 = this.createMinor(nArray, n, n2, n3);
        this.det(nArray2, 0, n3 - 1);
    }

    private int[] createMinor(int[] nArray, int n, int n2, int n3) {
        int n4 = n3 - 1;
        int[] nArray2 = new int[n4 * n4];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            if (i == n) continue;
            for (int j = 0; j < n3; ++j) {
                if (j == n2) continue;
                nArray2[n5++] = nArray[i * n3 + j];
            }
        }
        return nArray2;
    }

    private void det(int[] nArray, int n, int n2) {
        if (n2 == 1) {
            this.stream.print(this.a(nArray[0]));
        } else if (n2 == 2) {
            this.stream.print(this.a(nArray[0]) + "*" + this.a(nArray[3]) + " - " + this.a(nArray[1]) + "*" + this.a(nArray[2]));
        } else {
            int n3 = n2 - 1;
            for (int i = 0; i < n2; ++i) {
                int[] nArray2 = this.createMinor(nArray, 0, i, n2);
                int n4 = i;
                if (n4 % 2 == 0) {
                    this.stream.print(" + " + this.a(nArray[i]) + "*(");
                } else {
                    this.stream.print(" - " + this.a(nArray[i]) + "*(");
                }
                this.det(nArray2, n + 1, n3);
                this.stream.print(")");
            }
        }
    }

    private String a(int n) {
        int n2 = n / this.N + 1;
        int n3 = n % this.N + 1;
        return "a" + n2 + "" + n3;
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        GenerateInverseFromMinor generateInverseFromMinor = new GenerateInverseFromMinor();
        generateInverseFromMinor.createClass(5);
    }
}

