/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import extrabiomes.Extrabiomes;
import extrabiomes.blocks.BlockAutumnLeaves;
import extrabiomes.blocks.BlockCatTail;
import extrabiomes.blocks.BlockCustomFlower;
import extrabiomes.blocks.BlockCustomLog;
import extrabiomes.blocks.BlockCustomSapling;
import extrabiomes.blocks.BlockCustomTallGrass;
import extrabiomes.blocks.BlockGreenLeaves;
import extrabiomes.blocks.BlockKneeLog;
import extrabiomes.blocks.BlockLeafPile;
import extrabiomes.blocks.BlockMiniLog;
import extrabiomes.blocks.BlockMoreLeaves;
import extrabiomes.blocks.BlockNewLeaves;
import extrabiomes.blocks.BlockNewLog;
import extrabiomes.blocks.BlockNewQuarterLog;
import extrabiomes.blocks.BlockNewSapling;
import extrabiomes.blocks.BlockQuarterLog;
import extrabiomes.blocks.BlockRedRock;
import extrabiomes.blocks.GenericTerrainBlock;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.handlers.SaplingBonemealEventHandler;
import extrabiomes.handlers.SaplingBonemealNewEventHandler;
import extrabiomes.handlers.SaplingFuelHandler;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.helpers.ForestryModHelper;
import extrabiomes.items.ItemCatTail;
import extrabiomes.items.ItemCustomGreenLeaves;
import extrabiomes.items.ItemCustomLeaves;
import extrabiomes.items.ItemCustomMiniLog;
import extrabiomes.items.ItemCustomMoreLeaves;
import extrabiomes.items.ItemCustomNewLeaves;
import extrabiomes.items.ItemFlower;
import extrabiomes.items.ItemGrass;
import extrabiomes.items.ItemNewSapling;
import extrabiomes.items.ItemRedRock;
import extrabiomes.items.ItemSapling;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Blocks;
import extrabiomes.lib.Element;
import extrabiomes.lib.ModuleControlSettings;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.summa.worldgen.CatTailGenerator;
import extrabiomes.module.summa.worldgen.FlowerGenerator;
import extrabiomes.module.summa.worldgen.LeafPileGenerator;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.renderers.RenderKneeLog;
import extrabiomes.renderers.RenderMiniLog;
import extrabiomes.renderers.RenderNewQuarterLog;
import extrabiomes.renderers.RenderQuarterLog;
import extrabiomes.utility.MultiItemBlock;

public abstract class BlockHandler {
    private static void createAutumnLeaves() {
        int blockID = BlockSettings.AUTUMNLEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockAutumnLeaves block = new BlockAutumnLeaves(blockID, 3, akc.j, false);
        block.c("extrabiomes.leaves").b(true).c(0.2f).k(1).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemCustomLeaves.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("treeLeaves", (aqz)block);
        proxy.setBurnProperties(block.cF, 30, 60);
        Element.LEAVES_AUTUMN_BROWN.set(new ye((aqz)block, 1, BlockAutumnLeaves.BlockType.UMBER.metadata()));
        Element.LEAVES_AUTUMN_ORANGE.set(new ye((aqz)block, 1, BlockAutumnLeaves.BlockType.GOLDENROD.metadata()));
        Element.LEAVES_AUTUMN_PURPLE.set(new ye((aqz)block, 1, BlockAutumnLeaves.BlockType.VERMILLION.metadata()));
        Element.LEAVES_AUTUMN_YELLOW.set(new ye((aqz)block, 1, BlockAutumnLeaves.BlockType.CITRINE.metadata()));
        ye stack = new ye((aqz)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    public static void createBlocks() {
        BlockHandler.createAutumnLeaves();
        BlockHandler.createCattail();
        BlockHandler.createCrackedSand();
        BlockHandler.createFlower();
        BlockHandler.createGrass();
        BlockHandler.createGreenLeaves();
        BlockHandler.createNewLeaves();
        BlockHandler.createMoreLeaves();
        BlockHandler.createLeafPile();
        BlockHandler.createRedRock();
        BlockHandler.createSapling();
        BlockHandler.createNewSapling();
        BlockHandler.createLogs();
    }

    private static void createCattail() {
        int blockID = BlockSettings.CATTAIL.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCatTail block = new BlockCatTail(blockID, 79, akc.k);
        block.c("extrabiomes.cattail").c(0.0f).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemCatTail.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOre("reedTypha", (aqz)block);
        Element.CATTAIL.set(new ye((aqz)block));
        proxy.registerWorldGenerator(new CatTailGenerator(block.cF));
    }

    private static void createCrackedSand() {
        int blockID = BlockSettings.CRACKEDSAND.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        GenericTerrainBlock block = new GenericTerrainBlock(blockID, 0, akc.e);
        block.c("extrabiomes.crackedsand").c(1.2f).a(aqz.k).a(Extrabiomes.tabsEBXL);
        block.texturePath = "crackedsand";
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOre("sandCracked", (aqz)block);
        ye stack = new ye((aqz)block);
        Element.CRACKEDSAND.set(stack);
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.WASTELAND, block.cF, block.cF);
        ForestryModHelper.addToDiggerBackpack(stack);
        FacadeHelper.addBuildcraftFacade(block.cF);
    }

    private static void createFlower() {
        int blockID = BlockSettings.FLOWER.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomFlower block = new BlockCustomFlower(blockID, 32, akc.k);
        block.c("extrabiomes.flower").b(true).c(0.0f).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(block, ItemFlower.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        Element.AUTUMN_SHRUB.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.AUTUMN_SHRUB.metadata()));
        Element.HYDRANGEA.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.HYDRANGEA.metadata()));
        Element.FLOWER_ORANGE.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.ORANGE.metadata()));
        Element.FLOWER_PURPLE.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.PURPLE.metadata()));
        Element.FLOWER_WHITE.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.WHITE.metadata()));
        Element.ROOT.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.ROOT.metadata()));
        Element.TINY_CACTUS.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.TINY_CACTUS.metadata()));
        Element.TOADSTOOL.set(new ye((aqz)block, 1, BlockCustomFlower.BlockType.TOADSTOOL.metadata()));
        ForestryModHelper.addToForesterBackpack(new ye((aqz)block, 1, Short.MAX_VALUE));
        ForestryModHelper.registerBasicFlower(Element.HYDRANGEA.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_ORANGE.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_PURPLE.get());
        ForestryModHelper.registerBasicFlower(Element.FLOWER_WHITE.get());
        proxy.registerWorldGenerator(new FlowerGenerator(block.cF));
    }

    private static void createGrass() {
        int blockID = BlockSettings.GRASS.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomTallGrass block = new BlockCustomTallGrass(blockID, 48, akc.l);
        block.c("extrabiomes.tallgrass").c(0.0f).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemGrass.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.setBurnProperties(block.cF, 60, 100);
        Element.GRASS_BROWN.set(new ye((aqz)block, 1, BlockCustomTallGrass.BlockType.BROWN.metadata()));
        Element.GRASS_DEAD.set(new ye((aqz)block, 1, BlockCustomTallGrass.BlockType.DEAD.metadata()));
        Element.GRASS_BROWN_SHORT.set(new ye((aqz)block, 1, BlockCustomTallGrass.BlockType.SHORT_BROWN.metadata()));
        Element.GRASS_DEAD_TALL.set(new ye((aqz)block, 1, BlockCustomTallGrass.BlockType.DEAD_TALL.metadata()));
        Element.GRASS_DEAD_YELLOW.set(new ye((aqz)block, 1, BlockCustomTallGrass.BlockType.DEAD_YELLOW.metadata()));
        ye grassStack = Element.GRASS_BROWN.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (afe)new afz(grassStack.d, grassStack.k()), 100);
        grassStack = Element.GRASS_BROWN_SHORT.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.MOUNTAINRIDGE.getBiome(), (afe)new afz(grassStack.d, grassStack.k()), 100);
        grassStack = Element.GRASS_DEAD.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (afe)new afz(grassStack.d, grassStack.k()), 90);
        grassStack = Element.GRASS_DEAD_YELLOW.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (afe)new afz(grassStack.d, grassStack.k()), 90);
        grassStack = Element.GRASS_DEAD_TALL.get();
        BiomeHelper.addWeightedGrassGen(BiomeSettings.WASTELAND.getBiome(), (afe)new afz(grassStack.d, grassStack.k()), 35);
    }

    private static void createNewLeaves() {
        int blockID = BlockSettings.NEWLEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockNewLeaves block = new BlockNewLeaves(blockID, akc.j, false);
        block.c("extrabiomes.leaves").b(true).c(0.2f).k(1).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemCustomNewLeaves.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("treeLeaves", (aqz)block);
        proxy.setBurnProperties(block.cF, 30, 60);
        Element.LEAVES_BALD_CYPRESS.set(new ye((aqz)block, 1, BlockNewLeaves.BlockType.BALD_CYPRESS.metadata()));
        Element.LEAVES_JAPANESE_MAPLE.set(new ye((aqz)block, 1, BlockNewLeaves.BlockType.JAPANESE_MAPLE.metadata()));
        Element.LEAVES_JAPANESE_MAPLE_SHRUB.set(new ye((aqz)block, 1, BlockNewLeaves.BlockType.JAPANESE_MAPLE_SHRUB.metadata()));
        Element.LEAVES_RAINBOW_EUCALYPTUS.set(new ye((aqz)block, 1, BlockNewLeaves.BlockType.RAINBOW_EUCALYPTUS.metadata()));
        ye stack = new ye((aqz)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createMoreLeaves() {
        int blockID = BlockSettings.MORELEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockMoreLeaves block = new BlockMoreLeaves(blockID, akc.j, false);
        block.c("extrabiomes.leaves").b(true).c(0.2f).k(1).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemCustomMoreLeaves.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("treeLeaves", (aqz)block);
        proxy.setBurnProperties(block.cF, 30, 60);
        Element.LEAVES_SAKURA_BLOSSOM.set(new ye((aqz)block, 1, BlockMoreLeaves.BlockType.SAKURA_BLOSSOM.metadata()));
        ye stack = new ye((aqz)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createGreenLeaves() {
        int blockID = BlockSettings.GREENLEAVES.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockGreenLeaves block = new BlockGreenLeaves(blockID, akc.j, false);
        block.c("extrabiomes.leaves").b(true).c(0.2f).k(1).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemCustomGreenLeaves.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("treeLeaves", (aqz)block);
        proxy.setBurnProperties(block.cF, 30, 60);
        Element.LEAVES_ACACIA.set(new ye((aqz)block, 1, BlockGreenLeaves.BlockType.ACACIA.metadata()));
        Element.LEAVES_FIR.set(new ye((aqz)block, 1, BlockGreenLeaves.BlockType.FIR.metadata()));
        Element.LEAVES_REDWOOD.set(new ye((aqz)block, 1, BlockGreenLeaves.BlockType.REDWOOD.metadata()));
        Element.LEAVES_CYPRESS.set(new ye((aqz)block, 1, BlockGreenLeaves.BlockType.CYPRESS.metadata()));
        ye stack = new ye((aqz)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerLeaves(stack);
        ForestryModHelper.addToForesterBackpack(stack);
    }

    private static void createLeafPile() {
        int blockID = BlockSettings.LEAFPILE.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockLeafPile block = new BlockLeafPile(blockID, 64, akc.l);
        block.c("extrabiomes.leafpile").c(0.0f).b(true).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock(block, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.setBurnProperties(block.cF, 30, 60);
        Element.LEAFPILE.set(new ye((aqz)block));
        proxy.registerWorldGenerator(new LeafPileGenerator(block.cF));
    }

    private static void createLogs() {
        BlockHandler.createWood();
        BlockHandler.createMiniLogs();
        BlockHandler.createQuarterLogs();
        BlockHandler.createNewQuarterLogs();
        BlockHandler.createKneeLogs();
    }

    private static void createMiniLogs() {
        int blockID = BlockSettings.MINILOG.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockMiniLog block = new BlockMiniLog(blockID);
        Blocks.BLOCK_LOG_SAKURA_GROVE.set((aqz)block);
        block.c("extrabiomes.log").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((aqz)block, "axe", 0);
        proxy.registerBlock((aqz)block, ItemCustomMiniLog.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("logWood", (aqz)block);
        proxy.registerEventHandler((Object)block);
        proxy.setBurnProperties(block.cF, 5, 5);
        Element.LOG_SAKURA_BLOSSOM.set(new ye((aqz)block, 1, BlockMiniLog.BlockType.SAKURA_BLOSSOM.metadata()));
        ForestryModHelper.addToForesterBackpack(new ye((aqz)block, 1, Short.MAX_VALUE));
        BlockMiniLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderMiniLog()));
    }

    private static void createKneeLogs() {
        BlockKneeLog block = new BlockKneeLog(BlockSettings.KNEELOG.getID(), "baldcypress");
        if (!ModuleControlSettings.SUMMA.isEnabled() || BlockSettings.KNEELOG.getID() <= 0) {
            return;
        }
        block.c("extrabiomes.cypresskneelog").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((aqz)block, "axe", 0);
        proxy.registerBlock((aqz)block, zh.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("logWood", (aqz)block);
        proxy.registerEventHandler((Object)block);
        proxy.setBurnProperties(block.cF, 5, 5);
        BlockKneeLog block2 = new BlockKneeLog(BlockSettings.RAINBOWKNEELOG.getID(), "rainboweucalyptus");
        if (!ModuleControlSettings.SUMMA.isEnabled() || BlockSettings.RAINBOWKNEELOG.getID() <= 0) {
            return;
        }
        block2.c("extrabiomes.rainbowkneelog").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
        proxy.setBlockHarvestLevel((aqz)block2, "axe", 0);
        proxy.registerBlock((aqz)block2, zh.class, block2.a() + ":" + ((Object)((Object)block2)).getClass().getName());
        proxy.registerOreInAllSubblocks("logWood", (aqz)block2);
        proxy.registerEventHandler((Object)block2);
        proxy.setBurnProperties(block2.cF, 5, 5);
        Element.LOG_KNEE_BALD_CYPRESS.set(new ye((aqz)block, 1, Short.MAX_VALUE));
        Element.LOG_KNEE_RAINBOW_EUCALYPTUS.set(new ye((aqz)block2, 1, Short.MAX_VALUE));
        BlockKneeLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderKneeLog()));
        ForestryModHelper.addToForesterBackpack(new ye(block.cF, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ye(block2.cF, 1, Short.MAX_VALUE));
        FacadeHelper.addBuildcraftFacade(block.cF);
        FacadeHelper.addBuildcraftFacade(block2.cF);
    }

    private static void createNewQuarterLogs() {
        BlockNewQuarterLog block = new BlockNewQuarterLog(BlockSettings.NEWQUARTERLOG.getID(), "baldcypress");
        if (!ModuleControlSettings.SUMMA.isEnabled() || BlockSettings.NEWQUARTERLOG.getID() <= 0) {
            return;
        }
        block.c("extrabiomes.baldcypressquarter").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((aqz)block, "axe", 0);
        proxy.registerBlock((aqz)block, zh.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("logWood", (aqz)block);
        proxy.registerEventHandler((Object)block);
        proxy.setBurnProperties(block.cF, 5, 5);
        BlockNewQuarterLog block2 = new BlockNewQuarterLog(BlockSettings.RAINBOWQUARTERLOG.getID(), "rainboweucalyptus");
        if (!ModuleControlSettings.SUMMA.isEnabled() || BlockSettings.RAINBOWQUARTERLOG.getID() <= 0) {
            return;
        }
        block2.c("extrabiomes.rainboweucalyptusquarter").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
        proxy.setBlockHarvestLevel((aqz)block2, "axe", 0);
        proxy.registerBlock((aqz)block2, zh.class, block2.a() + ":" + ((Object)((Object)block2)).getClass().getName());
        proxy.registerOreInAllSubblocks("logWood", (aqz)block2);
        proxy.registerEventHandler((Object)block2);
        proxy.setBurnProperties(block2.cF, 5, 5);
        Element.LOG_QUARTER_BALD_CYPRESS.set(new ye((aqz)block, 1, Short.MAX_VALUE));
        Element.LOG_QUARTER_RAINBOW_EUCALYPTUS.set(new ye((aqz)block2, 1, Short.MAX_VALUE));
        BlockNewQuarterLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderNewQuarterLog()));
        ForestryModHelper.addToForesterBackpack(new ye(block.cF, 1, Short.MAX_VALUE));
        ForestryModHelper.addToForesterBackpack(new ye(block2.cF, 1, Short.MAX_VALUE));
        FacadeHelper.addBuildcraftFacade(block.cF);
        FacadeHelper.addBuildcraftFacade(block2.cF);
    }

    private static void createQuarterLogs() {
        int blockIDNW = BlockSettings.QUARTERLOG0.getID();
        int blockIDNE = BlockSettings.QUARTERLOG1.getID();
        int blockIDSW = BlockSettings.QUARTERLOG2.getID();
        int blockIDSE = BlockSettings.QUARTERLOG3.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockIDNE <= 0 || blockIDNW <= 0 || blockIDSE <= 0 || blockIDSW <= 0) {
            return;
        }
        BlockQuarterLog blockNW = new BlockQuarterLog(blockIDNW, 144, BlockQuarterLog.BarkOn.NW);
        BlockQuarterLog blockNE = new BlockQuarterLog(blockIDNE, 144, BlockQuarterLog.BarkOn.NE);
        BlockQuarterLog blockSW = new BlockQuarterLog(blockIDSW, 144, BlockQuarterLog.BarkOn.SW);
        BlockQuarterLog blockSE = new BlockQuarterLog(blockIDSE, 144, BlockQuarterLog.BarkOn.SE);
        for (BlockQuarterLog blockQuarterLog : new BlockQuarterLog[]{blockNW, blockNE, blockSW, blockSE}) {
            blockQuarterLog.c("extrabiomes.log.quarter").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
            CommonProxy proxy = Extrabiomes.proxy;
            proxy.setBlockHarvestLevel((aqz)blockQuarterLog, "axe", 0);
            proxy.registerBlock((aqz)blockQuarterLog, MultiItemBlock.class, blockQuarterLog.a() + ":" + blockQuarterLog.getBarkOnSides().toString() + ":" + ((Object)((Object)blockQuarterLog)).getClass().getName());
            proxy.registerOreInAllSubblocks("logWood", (aqz)blockQuarterLog);
            proxy.registerEventHandler((Object)blockQuarterLog);
            proxy.setBurnProperties(blockQuarterLog.cF, 5, 5);
        }
        Element.LOG_HUGE_FIR_NW.set(new ye((aqz)blockNW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_NE.set(new ye((aqz)blockNE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SW.set(new ye((aqz)blockSW, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_FIR_SE.set(new ye((aqz)blockSE, 1, BlockQuarterLog.BlockType.FIR.metadata()));
        Element.LOG_HUGE_OAK_NW.set(new ye((aqz)blockNW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_NE.set(new ye((aqz)blockNE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SW.set(new ye((aqz)blockSW, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_OAK_SE.set(new ye((aqz)blockSE, 1, BlockQuarterLog.BlockType.OAK.metadata()));
        Element.LOG_HUGE_REDWOOD_NW.set(new ye((aqz)blockNW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_NE.set(new ye((aqz)blockNE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SW.set(new ye((aqz)blockSW, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        Element.LOG_HUGE_REDWOOD_SE.set(new ye((aqz)blockSE, 1, BlockQuarterLog.BlockType.REDWOOD.metadata()));
        BlockQuarterLog.setRenderId(Extrabiomes.proxy.registerBlockHandler(new RenderQuarterLog()));
        for (BlockQuarterLog.BlockType blockType : BlockQuarterLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(blockSE.cF, blockType.metadata());
        }
    }

    private static void createRedRock() {
        int blockID = BlockSettings.REDROCK.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockRedRock block = new BlockRedRock(blockID, 2, akc.e);
        block.c("extrabiomes.redrock").c(1.5f).b(2.0f).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel(block, "pickaxe", 0);
        proxy.registerBlock(block, ItemRedRock.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        Element.RED_ROCK.set(new ye((aqz)block, 1, BlockRedRock.BlockType.RED_ROCK.metadata()));
        Element.RED_COBBLE.set(new ye((aqz)block, 1, BlockRedRock.BlockType.RED_COBBLE.metadata()));
        Element.RED_ROCK_BRICK.set(new ye((aqz)block, 1, BlockRedRock.BlockType.RED_ROCK_BRICK.metadata()));
        Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockActiveEvent(block));
        BiomeHelper.addTerrainBlockstoBiome(BiomeSettings.MOUNTAINRIDGE, block.cF, block.cF);
        ForestryModHelper.addToDiggerBackpack(new ye((aqz)block, 1, Short.MAX_VALUE));
        for (BlockRedRock.BlockType type : BlockRedRock.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(block.cF, type.metadata());
        }
    }

    private static void createSapling() {
        Element[] forestrySaplings;
        int blockID = BlockSettings.SAPLING.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomSapling block = new BlockCustomSapling(blockID, 16);
        block.c("extrabiomes.sapling").c(0.0f).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemSapling.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("treeSapling", (aqz)block);
        Element.SAPLING_ACACIA.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.ACACIA.metadata()));
        Element.SAPLING_AUTUMN_BROWN.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.UMBER.metadata()));
        Element.SAPLING_AUTUMN_ORANGE.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.GOLDENROD.metadata()));
        Element.SAPLING_AUTUMN_PURPLE.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.VERMILLION.metadata()));
        Element.SAPLING_AUTUMN_YELLOW.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.CITRINE.metadata()));
        Element.SAPLING_FIR.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.FIR.metadata()));
        Element.SAPLING_REDWOOD.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.REDWOOD.metadata()));
        Element.SAPLING_CYPRESS.set(new ye((aqz)block, 1, BlockCustomSapling.BlockType.CYPRESS.metadata()));
        ye stack = new ye((aqz)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerSapling(Element.SAPLING_ACACIA.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_BROWN.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_ORANGE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_PURPLE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_AUTUMN_YELLOW.get());
        ForestryModHelper.registerSapling(Element.SAPLING_FIR.get());
        ForestryModHelper.registerSapling(Element.SAPLING_REDWOOD.get());
        ForestryModHelper.registerSapling(Element.SAPLING_CYPRESS.get());
        ForestryModHelper.addToForesterBackpack(stack);
        for (Element sapling : forestrySaplings = new Element[]{Element.SAPLING_ACACIA, Element.SAPLING_AUTUMN_BROWN, Element.SAPLING_AUTUMN_ORANGE, Element.SAPLING_AUTUMN_PURPLE, Element.SAPLING_AUTUMN_YELLOW, Element.SAPLING_FIR, Element.SAPLING_CYPRESS}) {
            ForestryModHelper.registerGermling(sapling.get());
        }
        proxy.registerEventHandler(new SaplingBonemealEventHandler(block));
        proxy.registerFuelHandler(new SaplingFuelHandler(block.cF));
    }

    private static void createNewSapling() {
        Element[] forestrySaplings;
        int blockID = BlockSettings.NEWSAPLING.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockNewSapling block = new BlockNewSapling(blockID);
        block.c("extrabiomes.sapling").c(0.0f).a(aqz.j).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.registerBlock((aqz)block, ItemNewSapling.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("treeSapling", (aqz)block);
        Element.SAPLING_BALD_CYPRESS.set(new ye((aqz)block, 1, BlockNewSapling.BlockType.BALD_CYPRESS.metadata()));
        Element.SAPLING_JAPANESE_MAPLE.set(new ye((aqz)block, 1, BlockNewSapling.BlockType.JAPANESE_MAPLE.metadata()));
        Element.SAPLING_JAPANESE_MAPLE_SHRUB.set(new ye((aqz)block, 1, BlockNewSapling.BlockType.JAPANESE_MAPLE_SHRUB.metadata()));
        Element.SAPLING_RAINBOW_EUCALYPTUS.set(new ye((aqz)block, 1, BlockNewSapling.BlockType.RAINBOW_EUCALYPTUS.metadata()));
        Element.SAPLING_SAKURA_BLOSSOM.set(new ye((aqz)block, 1, BlockNewSapling.BlockType.SAKURA_BLOSSOM.metadata()));
        ye stack = new ye((aqz)block, 1, Short.MAX_VALUE);
        ForestryModHelper.registerSapling(Element.SAPLING_BALD_CYPRESS.get());
        ForestryModHelper.registerSapling(Element.SAPLING_JAPANESE_MAPLE.get());
        ForestryModHelper.registerSapling(Element.SAPLING_JAPANESE_MAPLE_SHRUB.get());
        ForestryModHelper.registerSapling(Element.SAPLING_RAINBOW_EUCALYPTUS.get());
        ForestryModHelper.registerSapling(Element.SAPLING_SAKURA_BLOSSOM.get());
        ForestryModHelper.addToForesterBackpack(stack);
        for (Element sapling : forestrySaplings = new Element[]{Element.SAPLING_JAPANESE_MAPLE, Element.SAPLING_JAPANESE_MAPLE_SHRUB, Element.SAPLING_SAKURA_BLOSSOM}) {
            ForestryModHelper.registerGermling(sapling.get());
        }
        proxy.registerEventHandler(new SaplingBonemealNewEventHandler(block));
        proxy.registerFuelHandler(new SaplingFuelHandler(block.cF));
    }

    private static void createWood() {
        int blockID = BlockSettings.CUSTOMLOG.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || blockID <= 0) {
            return;
        }
        BlockCustomLog block = new BlockCustomLog(blockID);
        block.c("extrabiomes.log").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
        CommonProxy proxy = Extrabiomes.proxy;
        proxy.setBlockHarvestLevel((aqz)block, "axe", 0);
        proxy.registerBlock((aqz)block, MultiItemBlock.class, block.a() + ":" + ((Object)((Object)block)).getClass().getName());
        proxy.registerOreInAllSubblocks("logWood", (aqz)block);
        proxy.registerEventHandler((Object)block);
        proxy.setBurnProperties(block.cF, 5, 5);
        Element.LOG_ACACIA.set(new ye((aqz)block, 1, BlockCustomLog.BlockType.ACACIA.metadata()));
        Element.LOG_FIR.set(new ye((aqz)block, 1, BlockCustomLog.BlockType.FIR.metadata()));
        Element.LOG_CYPRESS.set(new ye((aqz)block, 1, BlockCustomLog.BlockType.CYPRESS.metadata()));
        Element.LOG_JAPANESE_MAPLE.set(new ye((aqz)block, 1, BlockCustomLog.BlockType.JAPANESE_MAPLE.metadata()));
        ForestryModHelper.addToForesterBackpack(new ye((aqz)block, 1, Short.MAX_VALUE));
        for (BlockCustomLog.BlockType type : BlockCustomLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(block.cF, type.metadata());
        }
        int newblockID = BlockSettings.NEWLOG.getID();
        if (!ModuleControlSettings.SUMMA.isEnabled() || newblockID <= 0) {
            return;
        }
        BlockNewLog block2 = new BlockNewLog(newblockID);
        block2.c("extrabiomes.newlog").a(aqz.h).c(2.0f).b(aqz.O.a(null) * 5.0f).a(Extrabiomes.tabsEBXL);
        proxy.setBlockHarvestLevel((aqz)block2, "axe", 0);
        proxy.registerBlock((aqz)block2, MultiItemBlock.class, block2.a() + ":" + ((Object)((Object)block2)).getClass().getName());
        proxy.registerOreInAllSubblocks("logWood", (aqz)block2);
        proxy.registerEventHandler((Object)block2);
        proxy.setBurnProperties(block2.cF, 5, 5);
        Element.LOG_RAINBOW_EUCALYPTUS.set(new ye((aqz)block2, 1, BlockNewLog.BlockType.RAINBOW_EUCALYPTUS.metadata()));
        Element.LOG_AUTUMN.set(new ye((aqz)block2, 1, BlockNewLog.BlockType.AUTUMN.metadata()));
        Element.LOG_BALD_CYPRESS.set(new ye((aqz)block2, 1, BlockNewLog.BlockType.BALD_CYPRESS.metadata()));
        ForestryModHelper.addToForesterBackpack(new ye((aqz)block2, 1, Short.MAX_VALUE));
        for (BlockNewLog.BlockType type : BlockNewLog.BlockType.values()) {
            FacadeHelper.addBuildcraftFacade(block2.cF, type.metadata());
        }
    }
}

