/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.fx.ParticleLogic;
import mrtjp.projectred.core.utils.MathLib;

public class ParticleLogicArcToEntity
extends ParticleLogic {
    private Vector3 start;
    private nn target;
    private Vector3 firstControl;
    private Vector3 secondControl;
    private float percent;
    private float speed;
    private float offsetFactor;
    private float halfOffsetFactor;

    public ParticleLogicArcToEntity(Vector3 vector3, nn nn2) {
        this.start = vector3.copy();
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.target = nn2;
        this.generateControlPoints();
    }

    public ParticleLogicArcToEntity generateControlPoints() {
        this.firstControl = new Vector3(this.start.x + (this.target.u - this.start.x) / 3.0, this.start.y + (this.target.v - this.start.y) / 3.0, this.start.z + (this.target.w - this.start.z) / 3.0);
        this.secondControl = new Vector3(this.start.x + (this.target.u - this.start.x) / 3.0 * 2.0, this.start.y + (this.target.v - this.start.y) / 3.0 * 2.0, this.start.z + (this.target.w - this.start.z) / 3.0 * 2.0);
        double d = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double d2 = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vector3 vector3 = new Vector3(d, 0.0, d2);
        this.firstControl = this.firstControl.add(vector3);
        this.secondControl = this.secondControl.add(vector3);
        return this;
    }

    public ParticleLogicArcToEntity setControlPoints(Vector3 vector3, Vector3 vector32) {
        this.firstControl = vector3;
        this.secondControl = vector32;
        return this;
    }

    public ParticleLogicArcToEntity setSpeed(float f) {
        this.speed = f;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finishLogic();
            return;
        }
        Vector3 vector3 = MathLib.bezier(this.start, this.firstControl, this.secondControl, new Vector3(this.target.u, this.target.v, this.target.w).add(new Vector3(0.0, (double)this.target.f(), 0.0)), this.percent);
        this.particle.b(vector3.x, vector3.y, vector3.z);
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicArcToEntity(this.particle.position(), this.target).setSpeed(this.speed).setControlPoints(this.firstControl, this.secondControl).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

