/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.colour.ColourRGBA;

public class CCRenderState {
    private static boolean useNormals;
    private static boolean hasBrightness;
    private static int brightness;
    private static boolean useModelColours;
    private static int colour;
    private static boolean hasColour;
    private static int alpha;
    private static boolean alphaOverride;

    public static void useNormals(boolean b) {
        useNormals = b;
    }

    public static boolean useNormals() {
        return useNormals;
    }

    public static void useModelColours(boolean b) {
        useModelColours = b;
    }

    public static boolean useModelColours() {
        return useModelColours;
    }

    public static void setAlpha(int a) {
        alpha = a;
        alphaOverride = true;
    }

    public static void clearAlphaOverride() {
        alphaOverride = false;
    }

    public static void vertexColour(int c) {
        if (alphaOverride) {
            CCRenderState.setColour(c & 0xFFFFFF00 | alpha);
        } else {
            CCRenderState.setColour(c);
        }
    }

    public static void vertexColour(int r, int g, int b, int a) {
        if (alphaOverride) {
            bfq.a.a(r, g, b, alpha);
        } else {
            bfq.a.a(r, g, b, a);
        }
    }

    public static void setBrightness(acf world, int x, int y, int z) {
        aqz block = aqz.s[world.a(x, y, z)];
        CCRenderState.setBrightness(block == null ? world.h(x, y, z, 0) : block.e(world, x, y, z));
        CCRenderState.setColour(-1);
    }

    public static void setBrightness(int b) {
        hasBrightness = true;
        brightness = b;
        bfq.a.c(brightness);
    }

    public static void setColourOpaque(int c) {
        CCRenderState.setColour(c << 8 | 0xFF);
    }

    public static void setColour(int c) {
        hasColour = true;
        colour = c;
        bfq.a.a(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
    }

    public static void changeTexture(String texture) {
        CCRenderState.changeTexture(new bjo(texture));
    }

    public static void changeTexture(bjo texture) {
        atv.w().N.a(texture);
    }

    public static void apply() {
        if (hasBrightness) {
            bfq.a.c(brightness);
        }
        if (hasColour) {
            bfq.a.a(colour >> 24 & 0xFF, colour >> 16 & 0xFF, colour >> 8 & 0xFF, colour & 0xFF);
        }
    }

    public static void reset() {
        hasBrightness = false;
        useModelColours = false;
        hasColour = false;
        alphaOverride = false;
        useNormals = false;
    }

    public static void startDrawing(int i) {
        bfq.a.b(i);
        CCRenderState.apply();
    }

    public static void draw() {
        bfq.a.a();
    }

    public static void pullLightmap() {
        CCRenderState.setBrightness((int)bma.lastBrightnessY << 16 | (int)bma.lastBrightnessX);
    }

    public static void applyBrightnessTexCoords() {
        bma.a((int)bma.b, (float)(brightness & 0xFFFF), (float)(brightness >>> 16));
    }

    public static void glColour() {
        new ColourRGBA(colour).glColour();
    }
}

