/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.UV;
import codechicken.lib.render.UVScale;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.PipeDef;
import mrtjp.projectred.transportation.RoutedPayload;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderPipe {
    private static final ss dummyEntityItem = new ss(null);
    private static final bgw customRenderItem = new bgw(){

        public boolean shouldBob() {
            return false;
        }

        public boolean shouldSpreadItems() {
            return false;
        }
    };
    public static CCModel[] sideModels;
    public static CCModel[] centerModels;
    private static LazyLightMatrix dynamicLight;

    public static CCModel finishModel(CCModel cCModel) {
        cCModel.apply((IUVTransformation)new UVScale(0.0625));
        cCModel.shrinkUVs(5.0E-4);
        cCModel.computeNormals();
        cCModel.computeLighting(LightModel.standardLightModel);
        return cCModel;
    }

    public static void reverseOrder(Vertex5[] vertex5Array) {
        for (int i = 0; i < vertex5Array.length; i += 4) {
            Vertex5 vertex5 = vertex5Array[i + 1];
            vertex5Array[i + 1] = vertex5Array[i + 3];
            vertex5Array[i + 3] = vertex5;
        }
    }

    public static void render(BasicPipePart basicPipePart, Vector3 vector3) {
        dynamicLight.setPos((acf)basicPipePart.world(), basicPipePart.x(), basicPipePart.y(), basicPipePart.z());
        RenderPipe.render(basicPipePart, vector3, dynamicLight);
    }

    public static void render(BasicPipePart basicPipePart, Vector3 vector3, LazyLightMatrix lazyLightMatrix) {
        int n;
        Translation translation = new Translation(vector3);
        IconTransformation iconTransformation = new IconTransformation(PipeDef.VALID_PIPE()[basicPipePart.meta].sprites()[0]);
        int n2 = basicPipePart.connMap;
        if (Integer.bitCount(n2) == 2 && ((n2 & 3) == 3 || (n2 & 0xC) == 12 || (n2 & 0x30) == 48)) {
            for (n = 0; n < 3; ++n) {
                if (n2 >> n * 2 != 3) continue;
                centerModels[n].render((Transformation)translation, (IUVTransformation)iconTransformation);
            }
        } else {
            centerModels[3].render((Transformation)translation, (IUVTransformation)iconTransformation);
        }
        for (n = 0; n < 6; ++n) {
            if ((n2 & 1 << n) == 0) continue;
            iconTransformation = new IconTransformation(basicPipePart.getIcon(n));
            sideModels[n].render((Transformation)translation, (IUVTransformation)iconTransformation);
        }
    }

    public static void renderBreakingOverlay(ms ms2, BasicPipePart basicPipePart) {
        for (Cuboid6 cuboid6 : basicPipePart.getCollisionBoxes()) {
            RenderUtils.renderBlock((Cuboid6)cuboid6, (int)0, (Transformation)new Translation((double)basicPipePart.x(), (double)basicPipePart.y(), (double)basicPipePart.z()), (IUVTransformation)new IconTransformation(ms2), null);
        }
    }

    public static void renderInv(Transformation transformation, ms ms2) {
        IconTransformation iconTransformation = new IconTransformation(ms2);
        CCRenderState.setColour((int)-1);
        centerModels[3].render(transformation, (IUVTransformation)iconTransformation);
        for (int i = 0; i < 2; ++i) {
            sideModels[i].render(transformation, (IUVTransformation)iconTransformation);
        }
    }

    public static void renderItemFlow(BasicPipePart basicPipePart, Vector3 vector3, float f) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        for (RoutedPayload routedPayload : basicPipePart.itemFlow().Jdel()) {
            ForgeDirection forgeDirection = routedPayload.isEntering() ? routedPayload.input() : routedPayload.output();
            double d = routedPayload.progress() + routedPayload.speed() * f;
            double d2 = vector3.x + 0.5;
            double d3 = vector3.y + 0.25;
            double d4 = vector3.z + 0.5;
            switch (forgeDirection) {
                case UP: {
                    d3 = vector3.y - 0.25 + d;
                    break;
                }
                case DOWN: {
                    d3 = vector3.y - 0.25 + (1.0 - d);
                    break;
                }
                case SOUTH: {
                    d4 = vector3.z + d;
                    break;
                }
                case NORTH: {
                    d4 = vector3.z + (1.0 - d);
                    break;
                }
                case EAST: {
                    d2 = vector3.x + d;
                    break;
                }
                case WEST: {
                    d2 = vector3.x + (1.0 - d);
                    break;
                }
            }
            RenderPipe.doRenderItem(routedPayload, d2, d3, d4);
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private static void doRenderItem(RoutedPayload routedPayload, double d, double d2, double d3) {
        if (routedPayload == null || routedPayload.getItemStack() == null) {
            return;
        }
        float f = 0.7f;
        ye ye2 = routedPayload.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)d), (float)((float)d2), (float)((float)d3));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)f, (float)f, (float)f);
        dummyEntityItem.a(ye2);
        customRenderItem.a(dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        RenderPipe.prepareRenderState();
        GL11.glEnable((int)2896);
        bfq.a.a(PRColors.get((int)routedPayload.priority().color()).rgb, 32);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        RenderUtils.renderBlock((Cuboid6)Cuboid6.full, (int)0, (Transformation)new Translation(-0.5, -0.5, -0.5), null, null);
        RenderPipe.restoreRenderState();
        GL11.glPopMatrix();
    }

    private static void prepareRenderState() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        CCRenderState.reset();
        CCRenderState.startDrawing((int)7);
    }

    private static void restoreRenderState() {
        CCRenderState.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    static {
        customRenderItem.a(bgl.a);
        sideModels = new CCModel[6];
        centerModels = new CCModel[4];
        dynamicLight = new LazyLightMatrix();
        PipeModelGenerator.generateModels();
    }

    private static class PipeModelGenerator {
        double w = 0.25;
        double d = 0.0605;

        private PipeModelGenerator() {
        }

        public static void generateModels() {
            PipeModelGenerator pipeModelGenerator = new PipeModelGenerator();
            pipeModelGenerator.generateCenterModel();
            pipeModelGenerator.generateCrossExclusiveModels();
            pipeModelGenerator.generateSideModels();
            pipeModelGenerator.finishModels();
        }

        public void generateCenterModel() {
            CCModel cCModel = CCModel.quadModel((int)48);
            cCModel.verts[0] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 - this.w, 4.0, 8.0);
            cCModel.verts[1] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 - this.w, 12.0, 8.0);
            cCModel.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 12.0, 0.0);
            cCModel.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 4.0, 0.0);
            cCModel.verts[4] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 + this.w, 4.0, 8.0);
            cCModel.verts[5] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 + this.w, 12.0, 8.0);
            cCModel.verts[6] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 - this.w, 12.0, 0.0);
            cCModel.verts[7] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 - this.w, 4.0, 0.0);
            cCModel.generateSidedParts(0, Vector3.center);
            RenderPipe.centerModels[3] = cCModel;
        }

        public void generateCrossExclusiveModels() {
            int n;
            CCModel cCModel = CCModel.quadModel((int)48);
            cCModel.verts[0] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 - this.w, 0.0, 16.0);
            cCModel.verts[1] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 - this.w, 8.0, 16.0);
            cCModel.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 8.0, 8.0);
            cCModel.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 0.0, 8.0);
            cCModel.verts[4] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 + this.w, 0.0, 16.0);
            cCModel.verts[5] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 + this.w, 8.0, 16.0);
            cCModel.verts[6] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 - this.w, 8.0, 8.0);
            cCModel.verts[7] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 - this.w, 0.0, 8.0);
            for (n = 1; n < 4; ++n) {
                cCModel.generateSidedPart(0, n, Vector3.center, 0, 8 * n, 8);
            }
            for (n = 0; n < 48; ++n) {
                if (cCModel.verts[n] != null) continue;
                cCModel.verts[n] = new Vertex5();
            }
            RenderPipe.centerModels[0] = cCModel.copy().apply(Rotation.sideOrientation((int)2, (int)1).at(Vector3.center));
            RenderPipe.centerModels[1] = cCModel.copy().apply(Rotation.sideOrientation((int)0, (int)1).at(Vector3.center));
            RenderPipe.centerModels[2] = cCModel;
        }

        public void generateSideModels() {
            int n;
            CCModel cCModel = CCModel.quadModel((int)36);
            cCModel.verts[0] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 0.0, 0.0);
            cCModel.verts[1] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 0.0, 8.0);
            cCModel.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 4.0, 8.0);
            cCModel.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 4.0, 0.0);
            cCModel.verts[4] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w - this.d, 0.0, 0.0);
            cCModel.verts[5] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w - this.d, 0.0, 8.0);
            cCModel.verts[6] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w - this.d, 4.0, 8.0);
            cCModel.verts[7] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w - this.d, 4.0, 0.0);
            for (n = 1; n < 4; ++n) {
                cCModel.apply(Rotation.quarterRotations[n].at(Vector3.center), 0, n * 8, 8);
            }
            cCModel.verts[32] = new Vertex5(0.5 - this.w, 0.0, 0.5 - this.w, 8.0, 16.0);
            cCModel.verts[33] = new Vertex5(0.5 + this.w, 0.0, 0.5 - this.w, 16.0, 16.0);
            cCModel.verts[34] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, 8.0);
            cCModel.verts[35] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 8.0, 8.0);
            RenderPipe.sideModels[0] = cCModel;
            for (n = 1; n < 6; ++n) {
                RenderPipe.sideModels[n] = cCModel.copy().apply(Rotation.sideRotations[n].at(Vector3.center));
                if (n % 2 != 1) continue;
                Vertex5[] vertex5Array = RenderPipe.sideModels[n].verts;
                UVT uVT = new UVT(Rotation.quarterRotations[2].at(new Vector3(8.0, 0.0, 4.0)));
                for (int i = 0; i < 32; ++i) {
                    vertex5Array[i].apply((IUVTransformation)uVT);
                }
            }
        }

        public void finishModels() {
            for (CCModel cCModel : sideModels) {
                RenderPipe.finishModel(cCModel);
            }
            for (CCModel cCModel : centerModels) {
                RenderPipe.finishModel(cCModel);
            }
        }
    }

    public static class UVT
    implements IUVTransformation {
        public Transformation t;
        private Vector3 vec = new Vector3();

        public UVT(Transformation transformation) {
            this.t = transformation;
        }

        public void transform(UV uV) {
            this.vec.set(uV.u, 0.0, uV.v).apply(this.t);
            uV.set(this.vec.x, this.vec.z);
        }
    }
}

