/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;

public class ConnectionMatrix {
    private int mask = 0;
    private boolean dirty = false;

    public boolean isConnected(ForgeDirection direction) {
        return (this.mask & 1 << direction.ordinal()) != 0;
    }

    public void setConnected(ForgeDirection direction, boolean value) {
        if (this.isConnected(direction) != value) {
            this.mask ^= 1 << direction.ordinal();
            this.dirty = true;
        }
    }

    public int getMask() {
        return this.mask;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.mask);
    }

    public void readData(DataInputStream data) throws IOException {
        byte newMask = data.readByte();
        if (newMask != this.mask) {
            this.mask = newMask;
            this.dirty = true;
        }
    }
}

