/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.core.PluginInfo;
import forestry.api.core.Tabs;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.IResupplyHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.plugins.NativePlugin;
import forestry.storage.BackpackDefinition;
import forestry.storage.BackpackHelper;
import forestry.storage.GuiHandlerStorage;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemNaturalistBackpack;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRedstoneLogic;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;

@PluginInfo(pluginID="Storage", name="Storage", author="SirSengir", url="http://forestry.sengir.net/", description="Adds backpacks and crates.")
public class PluginStorage
extends NativePlugin
implements IOreDictionaryHandler {
    private ArrayList minerItems = new ArrayList();
    private ArrayList diggerItems = new ArrayList();
    private ArrayList foresterItems = new ArrayList();
    private ArrayList hunterItems = new ArrayList();
    private ArrayList adventurerItems = new ArrayList();
    private ArrayList builderItems = new ArrayList();
    static String CONFIG_CATEGORY = "backpacks";
    Configuration config;

    @Override
    public boolean isAvailable() {
        return !Config.disableStorage;
    }

    @Override
    public void preInit() {
        BackpackManager.backpackInterface = new BackpackHelper();
        super.preInit();
        this.createBackpackArrays();
    }

    @Override
    public void postInit() {
        super.postInit();
        PluginStorage.scanForItems();
        this.config = new Configuration();
        Property backpackConf = this.config.get("backpacks.miner.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the miner's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Miner's Backpack", backpackConf.Value, (IBackpackDefinition)BackpackManager.definitions.get("miner"));
        backpackConf = this.config.get("backpacks.digger.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the digger's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Digger's Backpack", backpackConf.Value, (IBackpackDefinition)BackpackManager.definitions.get("digger"));
        backpackConf = this.config.get("backpacks.forester.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the forester's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Forester's Backpack", backpackConf.Value, (IBackpackDefinition)BackpackManager.definitions.get("forester"));
        backpackConf = this.config.get("backpacks.hunter.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add additional blocks and items for the hunter's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Hunter's Backpack", backpackConf.Value, (IBackpackDefinition)BackpackManager.definitions.get("hunter"));
        backpackConf = this.config.get("backpacks.adventurer.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add blocks and items for the adventurer's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Adventurer's Backpack", backpackConf.Value, (IBackpackDefinition)BackpackManager.definitions.get("adventurer"));
        backpackConf = this.config.get("backpacks.builder.items", CONFIG_CATEGORY, "");
        backpackConf.Comment = "add blocks and items for the builder's backpack here in the format id:meta. separate blocks and items using ';'. wildcard for metadata: '*'";
        PluginStorage.parseBackpackItems("Builder's Backpack", backpackConf.Value, (IBackpackDefinition)BackpackManager.definitions.get("builder"));
        this.config.save();
    }

    public static void addBackpackItem(String pack, ItemStack stack) {
        if (stack == null) {
            return;
        }
        ((IBackpackDefinition)BackpackManager.definitions.get(pack)).addValidItem(stack);
    }

    public static void addBackpackItem(String pack, int id, int meta) {
        ((IBackpackDefinition)BackpackManager.definitions.get(pack)).addValidItem(new ItemStack(id, 1, meta));
    }

    public static void addBackpackItem(String pack, int id) {
        ((IBackpackDefinition)BackpackManager.definitions.get(pack)).addValidItem(new ItemStack(id, 1, Short.MAX_VALUE));
    }

    public static void scanForItems() {
        int id;
        for (id = 0; id < Block.field_71973_m.length; ++id) {
            try {
                if (Block.field_71973_m[id] == null) continue;
                if (Block.field_71973_m[id] instanceof IPlantable) {
                    PluginStorage.addBackpackItem("forester", id);
                }
                if (Block.field_71973_m[id] instanceof IShearable) {
                    PluginStorage.addBackpackItem("forester", id);
                }
                if (Block.field_71973_m[id] instanceof BlockLog) {
                    PluginStorage.addBackpackItem("forester", id);
                }
                if (Block.field_71973_m[id] instanceof BlockMelon) {
                    PluginStorage.addBackpackItem("forester", id);
                }
                if (Block.field_71973_m[id] instanceof BlockPumpkin) {
                    PluginStorage.addBackpackItem("forester", id);
                }
                if (Block.field_71973_m[id] instanceof BlockStairs || Block.field_71973_m[id].func_71857_b() == 10) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockFence || Block.field_71973_m[id].func_71857_b() == 11) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockFenceGate || Block.field_71973_m[id].func_71857_b() == 21) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockWall || Block.field_71973_m[id].func_71857_b() == 32) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockBasePressurePlate) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockLever) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockButton) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockTorch) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockRedstoneLogic) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockChest || Block.field_71973_m[id].func_71857_b() == 22) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockWorkbench) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockFurnace) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockLadder || Block.field_71973_m[id].func_71857_b() == 8) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (Block.field_71973_m[id] instanceof BlockTrapDoor) {
                    PluginStorage.addBackpackItem("builder", id);
                }
                if (!Block.field_71973_m[id].func_71917_a().contains("door")) continue;
                PluginStorage.addBackpackItem("builder", id);
                continue;
            }
            catch (Throwable error) {
                // empty catch block
            }
        }
        for (id = Item.field_77710_w.field_77779_bT; id < Item.field_77698_e.length; ++id) {
            try {
                if (Item.field_77698_e[id] == null) continue;
                if (Item.field_77698_e[id] instanceof IPlantable) {
                    PluginStorage.addBackpackItem("forester", id);
                    continue;
                }
                if (Item.field_77698_e[id] instanceof ItemFood) {
                    PluginStorage.addBackpackItem("hunter", id);
                    continue;
                }
                if (!(Item.field_77698_e[id] instanceof ItemDoor)) continue;
                PluginStorage.addBackpackItem("builder", id);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-backpack-items")) {
            String[] tokens = message.getStringValue().split("@");
            if (tokens.length != 2) {
                Logger.getLogger("Forestry").log(Level.INFO, String.format("Received an invalid 'add-backpack-items' request %s from mod %s", message.getStringValue(), message.getSender()));
                return true;
            }
            if (!BackpackManager.definitions.containsKey(tokens[0])) {
                Logger.getLogger("Forestry").log(Level.INFO, String.format("Received an invalid 'add-backpack-items' request %s from mod %s for non-existent backpack %s.", message.getStringValue(), message.getSender(), tokens[0]));
                return true;
            }
            PluginStorage.parseBackpackItems(tokens[0] + "'s Backpack", tokens[1], (IBackpackDefinition)BackpackManager.definitions.get(tokens[0]));
            return true;
        }
        return false;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }

    @Override
    protected void registerItems() {
        ForestryItem.apiaristBackpack.registerItem(new ItemNaturalistBackpack(Config.getOrCreateItemIdProperty("apiaristBag", 13048), GuiId.ApiaristBackpackGUI.ordinal(), new ItemNaturalistBackpack.BackpackDefinitionApiarist(13048, 0, "apiarist", 12882493)).func_77637_a(Tabs.tabApiculture), "apiaristBag");
        BackpackDefinition definition = (BackpackDefinition)((ItemBackpack)ForestryItem.apiaristBackpack.item()).getDefinition();
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.lepidopteristBackpack.registerItem(new ItemNaturalistBackpack(Config.getOrCreateItemIdProperty("lepidopteristBag", 13087), GuiId.LepidopteristBackpackGUI.ordinal(), new ItemNaturalistBackpack.BackpackDefinitionLepidopterist(13087, 0, "lepidopterist", 10050353)).func_77637_a(Tabs.tabLepidopterology), "lepidopteristBag");
        definition = (BackpackDefinition)((ItemBackpack)ForestryItem.lepidopteristBackpack.item()).getDefinition();
        BackpackManager.definitions.put(definition.getKey(), definition);
        definition = new BackpackDefinition(Config.getOrCreateItemIdProperty("minerBag", 13049), Config.getOrCreateItemIdProperty("minerBagT2", 13088), "miner", 3545213).setValidItems(BackpackManager.backpackItems[0]);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.minerBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT1, definition, EnumBackpackType.T1), "minerBag");
        ForestryItem.minerBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT2, definition, EnumBackpackType.T2), "minerBagT2");
        definition = new BackpackDefinition(Config.getOrCreateItemIdProperty("diggerBag", 13050), Config.getOrCreateItemIdProperty("diggerBagT2", 13089), "digger", 3554501).setValidItems(BackpackManager.backpackItems[1]);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.diggerBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT1, definition, EnumBackpackType.T1), "diggerBag");
        ForestryItem.diggerBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT2, definition, EnumBackpackType.T2), "diggerBagT2");
        definition = new BackpackDefinition(Config.getOrCreateItemIdProperty("foresterBag", 13051), Config.getOrCreateItemIdProperty("foresterBagT2", 13090), "forester", 3437607).setValidItems(BackpackManager.backpackItems[2]);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.foresterBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT1, definition, EnumBackpackType.T1), "foresterBag");
        ForestryItem.foresterBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT2, definition, EnumBackpackType.T2), "foresterBagT2");
        definition = new BackpackDefinition(Config.getOrCreateItemIdProperty("hunterBag", 13052), Config.getOrCreateItemIdProperty("hunterBagT2", 13091), "hunter", 4268565).setValidItems(BackpackManager.backpackItems[3]);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.hunterBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT1, definition, EnumBackpackType.T1), "hunterBag");
        ForestryItem.hunterBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT2, definition, EnumBackpackType.T2), "hunterBagT2");
        definition = new BackpackDefinition(Config.getOrCreateItemIdProperty("adventurerBackpack", 13096), Config.getOrCreateItemIdProperty("adventurerBackpackT2", 13097), "adventurer", 8370370).setValidItems(BackpackManager.backpackItems[4]);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.adventurerBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT1, definition, EnumBackpackType.T1), "adventurerBackpack");
        ForestryItem.adventurerBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT2, definition, EnumBackpackType.T2), "adventurerBackpackT2");
        definition = new BackpackDefinition(Config.getOrCreateItemIdProperty("builderBackpack", 13106), Config.getOrCreateItemIdProperty("builderBackpackT2", 13107), "builder", 0xDD3A3A).setValidItems(BackpackManager.backpackItems[5]);
        BackpackManager.definitions.put(definition.getKey(), definition);
        ForestryItem.builderBackpack.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT1, definition, EnumBackpackType.T1), "builderBackpack");
        ForestryItem.builderBackpackT2.registerItem(BackpackManager.backpackInterface.addBackpack(definition.idT2, definition, EnumBackpackType.T2), "builderBackpackT2");
    }

    @Override
    protected void registerBackpackItems() {
        this.minerItems.add(new ItemStack(Block.field_72089_ap));
        this.minerItems.add(new ItemStack(Block.field_71950_I));
        this.minerItems.add(new ItemStack(Item.field_77705_m));
        this.minerItems.add(new ItemStack(Block.field_72073_aw));
        this.minerItems.add(new ItemStack(Item.field_77702_n));
        this.minerItems.add(new ItemStack(Block.field_71941_G));
        this.minerItems.add(new ItemStack(Item.field_77717_p));
        this.minerItems.add(new ItemStack(Block.field_71949_H));
        this.minerItems.add(new ItemStack(Item.field_77703_o));
        this.minerItems.add(new ItemStack(Block.field_71947_N));
        this.minerItems.add(new ItemStack(Block.field_72047_aN));
        this.minerItems.add(new ItemStack(Item.field_77767_aC));
        this.minerItems.add(new ItemStack(Item.field_77756_aW, 1, 4));
        this.minerItems.add(new ItemStack(Item.field_77751_aT));
        this.minerItems.add(new ItemStack(Item.field_77817_bH));
        this.minerItems.add(new ItemStack(Block.field_72071_ax));
        this.minerItems.add(new ItemStack(Block.field_72076_bV));
        this.minerItems.add(new ItemStack(Block.field_72105_ah));
        this.minerItems.add(new ItemStack(Block.field_72083_ai));
        this.minerItems.add(new ItemStack(Block.field_71948_O));
        this.minerItems.add(ForestryItem.bronzePickaxe.getItemStack());
        this.minerItems.add(ForestryItem.kitPickaxe.getItemStack());
        this.minerItems.add(ForestryItem.brokenBronzePickaxe.getItemStack());
        this.minerItems.add(new ItemStack(Item.field_94583_ca));
        this.minerItems.add(new ItemStack(Block.field_72068_bR));
        this.minerItems.add(new ItemStack(Block.field_94342_cr));
        this.diggerItems.add(new ItemStack(Block.field_71979_v));
        this.diggerItems.add(new ItemStack(Block.field_71978_w));
        this.diggerItems.add(new ItemStack(Block.field_71939_E));
        this.diggerItems.add(new ItemStack(Block.field_71957_Q));
        this.diggerItems.add(new ItemStack(Block.field_71940_F));
        this.diggerItems.add(new ItemStack(Item.field_77804_ap));
        this.diggerItems.add(new ItemStack(Block.field_72012_bb));
        this.diggerItems.add(new ItemStack(Item.field_77757_aI));
        this.diggerItems.add(new ItemStack(Block.field_72013_bc));
        this.diggerItems.add(ForestryItem.bronzeShovel.getItemStack());
        this.diggerItems.add(ForestryItem.kitShovel.getItemStack());
        this.diggerItems.add(ForestryItem.brokenBronzeShovel.getItemStack());
        this.foresterItems.add(new ItemStack(Block.field_71987_y, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack((Block)Block.field_72103_ag));
        this.foresterItems.add(new ItemStack((Block)Block.field_72109_af));
        this.foresterItems.add(new ItemStack(Block.field_71951_J, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack(Item.field_77690_S));
        this.foresterItems.add(new ItemStack((Block)Block.field_72107_ae));
        this.foresterItems.add(new ItemStack((Block)Block.field_72097_ad));
        this.foresterItems.add(new ItemStack((Block)Block.field_71952_K, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack(Block.field_72038_aV));
        this.foresterItems.add(new ItemStack((Block)Block.field_71962_X, 1, Short.MAX_VALUE));
        this.foresterItems.add(new ItemStack(Block.field_71998_bu));
        this.foresterItems.add(new ItemStack(Block.field_72061_ba));
        this.foresterItems.add(new ItemStack(Block.field_71997_br));
        this.foresterItems.add(new ItemStack(Item.field_77706_j));
        this.foresterItems.add(new ItemStack(Item.field_77778_at));
        this.foresterItems.add(new ItemStack(Item.field_77727_br));
        this.foresterItems.add(new ItemStack(Item.field_77739_bg));
        this.foresterItems.add(new ItemStack(Item.field_77740_bh));
        this.foresterItems.add(new ItemStack(Item.field_77685_T));
        this.foresterItems.add(new ItemStack(ForestryBlock.saplingGE, 1));
        this.hunterItems.add(new ItemStack(Item.field_77676_L));
        this.hunterItems.add(new ItemStack(Item.field_77677_M));
        this.hunterItems.add(new ItemStack(Item.field_77722_bw));
        this.hunterItems.add(new ItemStack(Item.field_77731_bo));
        this.hunterItems.add(new ItemStack(Item.field_77755_aX));
        this.hunterItems.add(new ItemStack(Item.field_77683_K));
        this.hunterItems.add(new ItemStack(Item.field_77737_bm));
        this.hunterItems.add(new ItemStack(Item.field_77732_bp));
        this.hunterItems.add(new ItemStack(Item.field_77733_bq));
        this.hunterItems.add(new ItemStack(Item.field_77704_l));
        this.hunterItems.add(new ItemStack(Item.field_77784_aq));
        this.hunterItems.add(new ItemStack(Item.field_77782_ar));
        this.hunterItems.add(new ItemStack(Item.field_77741_bi));
        this.hunterItems.add(new ItemStack(Item.field_77734_bj));
        this.hunterItems.add(new ItemStack(Item.field_77735_bk));
        this.hunterItems.add(new ItemStack(Item.field_77736_bl));
        this.hunterItems.add(new ItemStack(Item.field_77770_aF));
        this.hunterItems.add(new ItemStack(Item.field_77764_aP));
        this.hunterItems.add(new ItemStack(Item.field_77730_bn));
        this.hunterItems.add(new ItemStack(Item.field_77728_bu));
        this.hunterItems.add(new ItemStack(Item.field_77723_bv));
        this.hunterItems.add(new ItemStack(Item.field_77761_aM));
        this.hunterItems.add(new ItemStack(Item.field_77756_aW, 1, 0));
        this.hunterItems.add(new ItemStack(Block.field_111038_cB));
        this.hunterItems.add(new ItemStack(Block.field_72101_ab));
        this.hunterItems.add(new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE));
        this.hunterItems.add(new ItemStack(Item.field_77748_bA));
        this.hunterItems.add(new ItemStack(Item.field_77725_bx));
        this.hunterItems.add(new ItemStack(Item.field_77813_bB));
        this.hunterItems.add(new ItemStack(Item.field_77754_aU));
        this.hunterItems.add(new ItemStack(Item.field_77753_aV));
        this.hunterItems.add(new ItemStack(Item.field_111214_ch));
        this.hunterItems.add(new ItemStack((Item)Item.field_77749_aR));
        this.hunterItems.add(new ItemStack(Item.field_111212_ci));
        this.hunterItems.add(new ItemStack(Item.field_77765_aA));
        this.hunterItems.add(new ItemStack(Item.field_111213_cg));
        this.hunterItems.add(new ItemStack(Item.field_111216_cf));
        this.hunterItems.add(new ItemStack(Item.field_111215_ce));
        this.builderItems.add(new ItemStack(Block.field_72069_aq));
        this.builderItems.add(new ItemStack(Block.field_72049_aP));
        this.builderItems.add(new ItemStack(Block.field_72035_aQ));
        this.builderItems.add(new ItemStack(Block.field_72078_bL));
        this.builderItems.add(new ItemStack(Block.field_72080_bM));
        this.builderItems.add(new ItemStack(ForestryBlock.candle));
        this.builderItems.add(new ItemStack(ForestryBlock.stump));
        this.builderItems.add(new ItemStack(Block.field_72007_bm, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Block.field_71981_t));
        this.builderItems.add(new ItemStack(Block.field_72081_al));
        this.builderItems.add(new ItemStack(Block.field_71988_x, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Block.field_111032_cD, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Block.field_72033_bA));
        this.builderItems.add(new ItemStack(Block.field_72098_bB));
        this.builderItems.add(new ItemStack(Block.field_72057_aH));
        this.builderItems.add(new ItemStack(Block.field_72063_at));
        this.builderItems.add(new ItemStack(Block.field_71992_bw));
        this.builderItems.add(new ItemStack(Block.field_72100_bC));
        this.builderItems.add(new ItemStack(Block.field_71995_bx));
        this.builderItems.add(new ItemStack(Block.field_71946_M));
        this.builderItems.add(new ItemStack(Block.field_72003_bq));
        this.builderItems.add(new ItemStack((Block)Block.field_72077_au));
        this.builderItems.add(new ItemStack(Block.field_72060_ay));
        this.builderItems.add(new ItemStack(Block.field_72051_aB));
        this.builderItems.add(new ItemStack(Block.field_72043_aJ));
        this.builderItems.add(new ItemStack(Block.field_82511_ci));
        this.builderItems.add(new ItemStack(Block.field_72034_aR));
        this.builderItems.add(new ItemStack(Block.field_72055_aF));
        this.builderItems.add(new ItemStack(Block.field_72031_aZ));
        this.builderItems.add(new ItemStack(Block.field_71993_bv));
        this.builderItems.add(new ItemStack(Block.field_72002_bp));
        this.builderItems.add(new ItemStack((Block)Block.field_72079_ak, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Block.field_94339_ct, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Block.field_94338_cu));
        this.builderItems.add(new ItemStack(Block.field_72088_bQ));
        this.builderItems.add(new ItemStack(Block.field_72072_bX));
        this.builderItems.add(new ItemStack(Block.field_72074_bW));
        this.builderItems.add(new ItemStack(Block.field_72070_bY));
        this.builderItems.add(new ItemStack(Block.field_82515_ce, 1, Short.MAX_VALUE));
        this.builderItems.add(new ItemStack(Item.field_77766_aB));
        this.builderItems.add(new ItemStack(Item.field_77790_av));
        this.builderItems.add(new ItemStack(Item.field_77792_au));
        this.builderItems.add(new ItemStack(Item.field_77742_bb));
        this.builderItems.add(new ItemStack(Item.field_94585_bY));
        this.builderItems.add(new ItemStack(Item.field_82802_bI));
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addRecipe(ForestryItem.apiaristBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), "stickWood", Character.valueOf('Y'), new ItemStack(ForestryBlock.apiculture, 1, 1));
        Proxies.common.addRecipe(ForestryItem.lepidopteristBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), "stickWood", Character.valueOf('Y'), new ItemStack(ForestryBlock.lepidopterology, 1, 0));
        Proxies.common.addRecipe(ForestryItem.minerBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), Item.field_77703_o, Character.valueOf('Y'), Block.field_72077_au);
        Proxies.common.addRecipe(ForestryItem.diggerBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), Block.field_71981_t, Character.valueOf('Y'), Block.field_72077_au);
        Proxies.common.addRecipe(ForestryItem.foresterBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), "logWood", Character.valueOf('Y'), Block.field_72077_au);
        Proxies.common.addRecipe(ForestryItem.hunterBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), Item.field_77676_L, Character.valueOf('Y'), Block.field_72077_au);
        Proxies.common.addRecipe(ForestryItem.adventurerBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), Item.field_77755_aX, Character.valueOf('Y'), Block.field_72077_au);
        Proxies.common.addRecipe(ForestryItem.builderBackpack.getItemStack(), "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('X'), Item.field_77683_K, Character.valueOf('V'), Item.field_77757_aI, Character.valueOf('Y'), Block.field_72077_au);
        RecipeManagers.carpenterManager.addRecipe(200, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.minerBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.minerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.diggerBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.diggerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.foresterBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.foresterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.hunterBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.hunterBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.adventurerBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.adventurerBackpack});
        RecipeManagers.carpenterManager.addRecipe(200, LiquidHelper.getLiquid("water", 1000), null, ForestryItem.builderBackpackT2.getItemStack(), new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), ForestryItem.craftingMaterial.getItemStack(1, 3), Character.valueOf('T'), ForestryItem.builderBackpack});
    }

    private void createBackpackArrays() {
        if (BackpackManager.backpackItems != null) {
            return;
        }
        BackpackManager.backpackItems = new ArrayList[6];
        BackpackManager.backpackItems[0] = this.minerItems;
        BackpackManager.backpackItems[1] = this.diggerItems;
        BackpackManager.backpackItems[2] = this.foresterItems;
        BackpackManager.backpackItems[3] = this.hunterItems;
        BackpackManager.backpackItems[4] = this.adventurerItems;
        BackpackManager.backpackItems[5] = this.builderItems;
    }

    @Override
    protected void registerCrates() {
    }

    private static void parseBackpackItems(String backpackIdent, String list, IBackpackDefinition target) {
        String[] items;
        for (String item : items = list.split("[;]+")) {
            if (item.isEmpty()) continue;
            String[] ident = item.split("[:]+");
            int id = 0;
            int meta = 0;
            if (ident.length > 1) {
                id = Integer.parseInt(ident[0].trim());
                meta = ident[1].trim().equals("*") ? Short.MAX_VALUE : Integer.parseInt(ident[1].trim());
            } else {
                id = Integer.parseInt(ident[0].trim());
            }
            if (id <= 0) continue;
            if (id < Block.field_71973_m.length && Block.field_71973_m[id] != null || Item.field_77698_e[id] != null) {
                FMLCommonHandler.instance().getFMLLogger().finer("Adding block/item of (" + id + ":" + meta + ") to " + backpackIdent);
                target.addValidItem(new ItemStack(id, 1, meta));
                continue;
            }
            FMLCommonHandler.instance().getFMLLogger().warning("Failed to add block/item of (" + id + ":" + meta + ") to " + backpackIdent + " since it was null.");
        }
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return this;
    }

    @Override
    public void onOreRegistration(String name, ItemStack ore) {
        this.createBackpackArrays();
        if (ore == null) {
            Proxies.log.warning("An ore/item of type %s was registered with the Forge ore dictionary, however the passed itemstack is null. Someone broke it. :(", (Object)name);
            return;
        }
        if (name.startsWith("ingot")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("ore")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("gem")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("dust")) {
            this.minerItems.add(ore);
        } else if (name.startsWith("crystal")) {
            this.minerItems.add(ore);
        } else if (name.matches("dropUranium")) {
            this.minerItems.add(ore);
        } else if (name.equals("treeLeaves") || name.equals("treeSapling") || name.equals("logWood")) {
            this.foresterItems.add(ore);
        } else if (name.equals("stairWood") || name.equals("plankWood") || name.equals("slabWood")) {
            this.builderItems.add(ore);
        } else if (name.startsWith("wood")) {
            this.foresterItems.add(ore);
        }
    }
}

