/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TravelingItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IAllele;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.pipes.EnumFilterType;
import forestry.pipes.PipeIconProvider;
import forestry.pipes.PipeLogicPropolis;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsPropolis
extends Pipe
implements IPipeTransportItemsHook {
    public final PipeLogicPropolis pipeLogic = new PipeLogicPropolis(this);
    IIconProvider provider;

    public PipeItemsPropolis(int itemID) {
        super((PipeTransport)new PipeTransportItems(), itemID);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.pipeLogic.readFromNBT(nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.pipeLogic.writeToNBT(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        if (this.provider == null) {
            this.provider = new PipeIconProvider();
        }
        return this.provider;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return direction.ordinal() + 1;
    }

    public boolean blockActivated(EntityPlayer player) {
        if (!Proxies.common.isSimulating(this.getWorld())) {
            return true;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().field_77993_c < Block.field_71973_m.length && Block.field_71973_m[player.func_71045_bC().field_77993_c] instanceof BlockGenericPipe) {
            return false;
        }
        player.openGui(ForestryAPI.instance, GuiId.PropolisPipeGUI.ordinal(), player.field_70170_p, this.container.field_70329_l, this.container.field_70330_m, this.container.field_70327_n);
        return true;
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, TravelingItem item) {
        LinkedList<ForgeDirection> filteredOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> typedOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaultOrientations = new LinkedList<ForgeDirection>();
        EnumFilterType type = EnumFilterType.getType(item.getItemStack());
        IBee bee = null;
        if (type != EnumFilterType.ITEM) {
            bee = PluginApiculture.beeInterface.getMember(item.getItemStack());
        }
        for (ForgeDirection dir : possibleOrientations) {
            if (this.pipeLogic.isClosed(dir)) continue;
            if (this.pipeLogic.isIndiscriminate(dir)) {
                defaultOrientations.add(dir);
                continue;
            }
            if (!this.pipeLogic.matchType(dir, type, bee)) continue;
            if (type == EnumFilterType.ITEM) {
                filteredOrientations.add(dir);
                continue;
            }
            ArrayList filters = this.pipeLogic.getGenomeFilters(dir);
            if (filters.size() <= 0) {
                typedOrientations.add(dir);
                continue;
            }
            for (IAllele[] pattern : filters) {
                if (!this.pipeLogic.matchAllele(pattern[0], bee.getIdent()) || !this.pipeLogic.matchAllele(pattern[1], bee.getGenome().getSecondary().getUID())) continue;
                filteredOrientations.add(dir);
            }
        }
        if (filteredOrientations.size() > 0) {
            return filteredOrientations;
        }
        if (typedOrientations.size() > 0) {
            return typedOrientations;
        }
        return defaultOrientations;
    }

    public void entityEntered(TravelingItem item, ForgeDirection orientation) {
        try {
            item.setSpeed(0.19999999f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void readjustSpeed(TravelingItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }
}

