/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.farming.IFarmHousing;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropPeat;
import forestry.farming.logic.FarmLogicWatered;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class FarmLogicPeat
extends FarmLogicWatered {
    public FarmLogicPeat(IFarmHousing housing) {
        super(housing, new ItemStack[]{new ItemStack(ForestryBlock.soil.field_71990_ca, 1, 1)}, new ItemStack[]{new ItemStack(ForestryBlock.soil.field_71990_ca, 1, 1)}, new ItemStack[]{new ItemStack(Block.field_71979_v), new ItemStack((Block)Block.field_71980_u)});
    }

    @Override
    public int getFertilizerConsumption() {
        return 2;
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Peat Bog";
        }
        return "Managed Peat Bog";
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public Collection harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<CropPeat> crops = new Stack<CropPeat>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            ItemStack occupant = this.getAsItemStack(position);
            if (occupant.field_77993_c != ForestryBlock.soil.field_71990_ca) continue;
            int type = occupant.func_77960_j() & 3;
            int maturity = occupant.func_77960_j() >> 2;
            if (type != 1 || maturity < 3) continue;
            crops.push(new CropPeat(this.world, position));
        }
        return crops;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return ForestryItem.peat.item().func_77617_a(0);
    }
}

