/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import buildcraft.api.power.PowerHandler;
import forestry.api.core.ITileStructure;
import forestry.api.farming.IFarmHousing;
import forestry.core.GameMode;
import forestry.core.interfaces.IPowerHandler;
import forestry.farming.gadgets.TileFarm;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class TileGearbox
extends TileFarm
implements IPowerHandler {
    public static int WORK_CYCLES = 4;
    public static int MIN_ENERGY_RECEIVED = 5;
    public static int MAX_ENERGY_RECEIVED = 20;
    public static int MIN_ACTIVATION_ENERGY = 5;
    public static int MAX_ENERGY = 1000;
    private int activationDelay = 0;
    private int previousDelays = 0;
    private int workCounter;
    PowerHandler powerProvider = new PowerHandler(this, PowerHandler.Type.MACHINE);

    public TileGearbox() {
        this.powerProvider.configurePowerPerdition(0, 100);
        this.powerProvider.configure(MIN_ENERGY_RECEIVED, Math.round((float)MAX_ENERGY_RECEIVED * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round((float)MIN_ACTIVATION_ENERGY * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")), Math.round((float)MAX_ENERGY * GameMode.getGameMode().getFloatSetting("energy.demand.modifier")));
        this.fixedType = 4;
    }

    @Override
    protected void createInventory() {
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.powerProvider.readFromNBT(nbttagcompound);
        this.activationDelay = nbttagcompound.func_74762_e("ActivationDelay");
        this.previousDelays = nbttagcompound.func_74762_e("PrevDelays");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        this.powerProvider.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("ActivationDelay", this.activationDelay);
        nbttagcompound.func_74768_a("PrevDelays", this.previousDelays);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerProvider.getPowerReceiver();
    }

    @Override
    public PowerHandler getPowerHandler() {
        return this.powerProvider;
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.activationDelay > 0) {
            --this.activationDelay;
            return;
        }
        if (this.workCounter >= WORK_CYCLES && this.field_70331_k.func_82737_E() % 5L == 0L) {
            ITileStructure central = this.getCentralTE();
            if (!(central instanceof IFarmHousing)) {
                return;
            }
            if (((IFarmHousing)((Object)central)).doWork()) {
                this.workCounter = 0;
                this.previousDelays = 0;
            } else {
                this.activationDelay = 10 * this.previousDelays < 120 ? 10 * this.previousDelays : 120;
                ++this.previousDelays;
            }
        }
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (this.workCounter < WORK_CYCLES) {
            this.powerProvider.useEnergy(MIN_ACTIVATION_ENERGY, MIN_ACTIVATION_ENERGY, true);
            ++this.workCounter;
        }
    }
}

