/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.core.Tabs;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.genetics.Tree;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.network.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.Utils;
import forestry.plugins.PluginArboriculture;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable {
    private EnumGermlingType type;

    public ItemGermlingGE(int id, EnumGermlingType type) {
        super(id);
        this.type = type;
        this.func_77637_a(Tabs.tabArboriculture);
    }

    @Override
    protected IIndividual getIndividual(ItemStack itemstack) {
        return new Tree(itemstack.func_77978_p());
    }

    private IAlleleTreeSpecies getPrimarySpecies(ItemStack itemstack) {
        ITree tree = PluginArboriculture.treeInterface.getMember(itemstack);
        if (tree == null) {
            return (IAlleleTreeSpecies)PluginArboriculture.treeInterface.getDefaultTemplate()[EnumTreeChromosome.SPECIES.ordinal()];
        }
        return tree.getGenome().getPrimary();
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 0;
    }

    public String func_77628_j(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return "Unknown";
        }
        IIndividual individual = this.getIndividual(itemstack);
        return individual.getDisplayName() + " " + this.type.getName();
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IIndividual individual : PluginArboriculture.treeInterface.getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
            itemList.add(PluginArboriculture.treeInterface.getMemberStack((ITree)individual, this.type.ordinal()));
        }
    }

    @Override
    public int func_82790_a(ItemStack itemstack, int renderPass) {
        return this.getPrimarySpecies(itemstack).getGermlingColour(this.type, renderPass);
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public int func_94901_k() {
        return this.type == EnumGermlingType.SAPLING ? SpriteSheet.BLOCKS.getSheetOrdinal() : SpriteSheet.ITEMS.getSheetOrdinal();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack itemstack, int renderPass) {
        IAlleleTreeSpecies species = this.getPrimarySpecies(itemstack);
        return species.getGermlingIcon(this.type, renderPass);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float facingX, float facingY, float facingZ) {
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        ITree tree = PluginArboriculture.treeInterface.getMember(itemstack);
        if (tree == null) {
            return false;
        }
        if (this.type == EnumGermlingType.SAPLING) {
            int yShift;
            if (!Utils.isReplaceableBlock(world, x, y, z)) {
                if (!world.func_72799_c(x, y + 1, z)) {
                    return false;
                }
                yShift = 1;
            } else {
                yShift = 0;
            }
            if (!tree.canStay(world, x, y + yShift, z)) {
                return false;
            }
            if (PluginArboriculture.treeInterface.plantSapling(world, tree, player.field_71092_bJ, x, y + yShift, z)) {
                Proxies.common.addBlockPlaceEffects(world, x, y, z, world.func_72798_a(x, y + yShift, z), 0);
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
                return true;
            }
            return false;
        }
        if (this.type == EnumGermlingType.POLLEN) {
            TileEntity target = world.func_72796_p(x, y, z);
            if (!(target instanceof IPollinatable)) {
                return false;
            }
            IPollinatable pollinatable = (IPollinatable)target;
            if (!pollinatable.canMateWith(tree)) {
                return false;
            }
            pollinatable.mateWith(tree);
            Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, world, x, y, z, world.func_72798_a(x, y, z), 0);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    public float getFermentationModifier(ItemStack itemstack) {
        ITree tree = PluginArboriculture.treeInterface.getMember(itemstack);
        if (tree == null) {
            return 1.0f;
        }
        return tree.getGenome().getSappiness() * 10.0f;
    }
}

