/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import forestry.core.render.TextureManager;
import forestry.core.utils.BlockUtil;
import forestry.plugins.PluginArboriculture;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderPod
extends FruitProviderNone {
    private static ItemStack[] DUMMY = new ItemStack[0];
    private EnumPodType type;
    private ItemStack[] drop;

    public FruitProviderPod(String key, IFruitFamily family, EnumPodType type, ItemStack ... dropOnMature) {
        super(key, family);
        this.type = type;
        this.drop = dropOnMature;
    }

    @Override
    public boolean requiresFruitBlocks() {
        return true;
    }

    @Override
    public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
        if (this.drop == null || this.drop.length == 0) {
            return DUMMY;
        }
        if (ripeningTime >= 2) {
            ItemStack[] dropping = new ItemStack[this.drop.length];
            for (int i = 0; i < this.drop.length; ++i) {
                dropping[i] = this.drop[i].func_77946_l();
            }
            return dropping;
        }
        return DUMMY;
    }

    @Override
    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, int x, int y, int z) {
        if (world.field_73012_v.nextFloat() > genome.getSappiness()) {
            return false;
        }
        if (this.type == EnumPodType.COCOA) {
            return BlockUtil.tryPlantPot(world, x, y, z, Block.field_72086_bP.field_71990_ca);
        }
        return PluginArboriculture.treeInterface.setFruitBlock(world, (IAlleleFruit)genome.getActiveAllele(EnumTreeChromosome.FRUITS.ordinal()), genome.getSappiness(), this.type.uids, x, y, z);
    }

    @Override
    public short getIconIndex(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime, boolean fancy) {
        return this.type.uids[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        if (this.type == EnumPodType.COCOA) {
            return;
        }
        TextureManager.getInstance().registerTexUID(register, this.type.uids[0], "pods/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".0");
        TextureManager.getInstance().registerTexUID(register, this.type.uids[1], "pods/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".1");
        TextureManager.getInstance().registerTexUID(register, this.type.uids[2], "pods/" + this.type.toString().toLowerCase(Locale.ENGLISH) + ".2");
    }

    public static enum EnumPodType {
        COCOA(2000, 2001, 2002),
        DATES(2010, 2011, 2012),
        PAPAYA(2013, 2014, 2015);

        public final short[] uids;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private EnumPodType(short stage1) {
            void stage3;
            void stage2;
            this.uids = new short[]{stage1, stage2, stage3};
        }
    }
}

