/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.gadgets.TileAlvearyFan;
import forestry.apiculture.gadgets.TileAlvearyHeater;
import forestry.apiculture.gadgets.TileAlvearyHygroregulator;
import forestry.apiculture.gadgets.TileAlvearyPlain;
import forestry.apiculture.gadgets.TileAlvearySieve;
import forestry.apiculture.gadgets.TileAlvearyStabiliser;
import forestry.apiculture.gadgets.TileAlvearySwarmer;
import forestry.core.gadgets.BlockStructure;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAlveary
extends BlockStructure {
    public static final int PLAIN = 0;
    public static final int ENTRANCE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int TX_55_SWOF = 5;
    public static final int TX_56_SWON = 6;
    public static final int TX_57_HTOF = 7;
    public static final int TX_58_HTON = 8;
    public static final int TX_71_FNOF = 9;
    public static final int TX_72_FNON = 10;
    public static final int TX_73_VLVE = 11;
    public static final int STABILISER = 12;
    public static final int SIEVE = 13;
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public BlockAlveary(int id) {
        super(id, new MaterialBeehive(false));
        this.func_71848_c(1.0f);
        if (id == 1382) {
            this.func_71849_a(Tabs.tabApiculture);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List list) {
        if (id != 1382) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (i == 1) continue;
            list.add(new ItemStack(this.field_71990_ca, 1, i));
        }
    }

    public int func_71857_b() {
        return 0;
    }

    public boolean func_71886_c() {
        return true;
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        drop.add(new ItemStack(this.field_71990_ca, 1, metadata != 1 ? metadata : 0));
        return drop;
    }

    public int func_71873_h(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta != 1 ? meta : 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 2: {
                return new TileAlvearySwarmer();
            }
            case 3: {
                return new TileAlvearyFan();
            }
            case 4: {
                return new TileAlvearyHeater();
            }
            case 5: {
                return new TileAlvearyHygroregulator();
            }
            case 6: {
                return new TileAlvearyStabiliser();
            }
            case 7: {
                return new TileAlvearySieve();
            }
        }
        return new TileAlvearyPlain();
    }

    public TileEntity func_72274_a(World world) {
        return this.createTileEntity(world, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.icons = new Icon[14];
        this.icons[0] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.plain");
        this.icons[1] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.entrance");
        this.icons[2] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.bottom");
        this.icons[3] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.left");
        this.icons[4] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.right");
        this.icons[5] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.swarmer.off");
        this.icons[6] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.swarmer.on");
        this.icons[7] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.heater.off");
        this.icons[8] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.heater.on");
        this.icons[9] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.fan.off");
        this.icons[10] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.fan.on");
        this.icons[11] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.valve");
        this.icons[12] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.stabiliser");
        this.icons[13] = TextureManager.getInstance().registerTex(register, "apiculture/alveary.sieve");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        if (!(metadata > 1 && metadata != 7 && metadata != 2 && metadata != 6 || side != 1 && side != 0)) {
            return this.icons[2];
        }
        switch (metadata) {
            case 1: {
                return this.icons[1];
            }
            case 2: {
                return this.icons[5];
            }
            case 3: {
                return this.icons[9];
            }
            case 4: {
                return this.icons[7];
            }
            case 5: {
                return this.icons[11];
            }
            case 6: {
                return this.icons[12];
            }
            case 7: {
                return this.icons[13];
            }
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 1) {
            return this.func_71858_a(side, meta);
        }
        if (meta > 1) {
            return this.getBlockTextureFromSideAndTile(world, x, y, z, side);
        }
        int idXP = world.func_72798_a(x + 1, y, z);
        int idXM = world.func_72798_a(x - 1, y, z);
        if (idXP == this.field_71990_ca && idXM != this.field_71990_ca) {
            if (world.func_72805_g(x + 1, y, z) == 1) {
                if (world.func_72798_a(x, y, z + 1) != this.field_71990_ca) {
                    return this.switchForSide(42, side);
                }
                return this.switchForSide(41, side);
            }
            return this.func_71858_a(side, meta);
        }
        if (idXP != this.field_71990_ca && idXM == this.field_71990_ca) {
            if (world.func_72805_g(x - 1, y, z) == 1) {
                if (world.func_72798_a(x, y, z + 1) != this.field_71990_ca) {
                    return this.switchForSide(41, side);
                }
                return this.switchForSide(42, side);
            }
            return this.func_71858_a(side, meta);
        }
        return this.func_71858_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    private Icon getBlockTextureFromSideAndTile(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null || !(tile instanceof TileAlveary)) {
            return this.func_71858_a(side, 0);
        }
        return this.icons[((TileAlveary)tile).getBlockTexture(side, world.func_72805_g(x, y, z))];
    }

    @SideOnly(value=Side.CLIENT)
    private Icon switchForSide(int textureId, int side) {
        if (side == 4 || side == 5) {
            if (textureId == 41) {
                return this.icons[3];
            }
            return this.icons[4];
        }
        if (textureId == 41) {
            return this.icons[4];
        }
        return this.icons[3];
    }
}

