/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.handler.MultipartProxy;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import mrtjp.projectred.core.CommandDebug;
import mrtjp.projectred.transmission.IWirePart;

public class WirePropogator {
    private static Field wiresProvidePower = aqb.class.getDeclaredFields()[0];
    public static boolean redwiresProvidePower = true;
    private static ThreadLocal<Boolean> redwiresConnectable = new ThreadLocal();
    private static TMultiPart notApart = new TMultiPart(){

        public String getType() {
            return null;
        }
    };
    private static Stack<PropogationRun> reusableRuns;
    private static PropogationRun currentRun;
    private static PropogationRun finishing;

    public static void setWiresProvidePower(boolean bl) {
        try {
            wiresProvidePower.setBoolean(aqz.aA, bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean redwiresConnectable() {
        Boolean bl = redwiresConnectable.get();
        return bl == null ? true : bl;
    }

    public static void setRedwiresConnectable(boolean bl) {
        redwiresConnectable.set(bl);
    }

    private static PropogationRun getRun() {
        if (reusableRuns.isEmpty()) {
            return new PropogationRun();
        }
        return reusableRuns.pop();
    }

    public static void addNeighborChange(BlockCoord blockCoord) {
        currentRun.neighborChanges.add(blockCoord);
    }

    public static void addPartChange(TMultiPart tMultiPart) {
        currentRun.partChanges.put((Object)tMultiPart.tile(), (Object)tMultiPart);
    }

    public static void logCalculation() {
        if (finishing != null) {
            finishing.recalcs++;
        }
    }

    public static void propogateTo(IWirePart iWirePart, TMultiPart tMultiPart, int n) {
        PropogationRun propogationRun = currentRun;
        if (propogationRun == null) {
            propogationRun = WirePropogator.getRun();
        }
        propogationRun.add(iWirePart, tMultiPart, n);
        if (currentRun != propogationRun) {
            if (currentRun != null) {
                throw new RuntimeException("Report this to ProjectRed developers");
            }
            propogationRun.start(finishing, iWirePart.world());
        }
    }

    public static void propogateTo(IWirePart iWirePart, int n) {
        WirePropogator.propogateTo(iWirePart, notApart, n);
    }

    public static void propogateAnalogDrop(IWirePart iWirePart) {
        currentRun.addAnalogDrop(iWirePart);
    }

    static {
        try {
            wiresProvidePower.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        reusableRuns = new Stack();
        currentRun = null;
        finishing = null;
    }

    private static class PropogationRun {
        private abw world;
        private PropogationRun parent;
        private TMultiPart lastCaller;
        private int count;
        private int recalcs;
        private Multimap<TileMultipart, TMultiPart> partChanges = HashMultimap.create();
        private HashSet<BlockCoord> neighborChanges = new HashSet();
        private LinkedList<Propogation> propogationList = new LinkedList();
        private LinkedList<Propogation> analogDrops = new LinkedList();

        private PropogationRun() {
        }

        public void clear() {
            this.partChanges.clear();
            this.neighborChanges.clear();
            this.count = 0;
            this.recalcs = 0;
            this.lastCaller = null;
            reusableRuns.add(this);
        }

        public void finish() {
            currentRun = null;
            if (this.partChanges.isEmpty() && this.neighborChanges.isEmpty()) {
                finishing = this.parent;
                this.clear();
                return;
            }
            finishing = this;
            if (CommandDebug.WIRE_READING) {
                System.out.println("" + this.count + " propogations, " + this.partChanges.size() + " part changes, " + this.neighborChanges.size() + " block updates");
            }
            for (Map.Entry object : this.partChanges.asMap().entrySet()) {
                Collection collection = (Collection)object.getValue();
                for (TMultiPart tMultiPart : collection) {
                    ((IWirePart)tMultiPart).onSignalUpdate();
                }
                ((TileMultipart)object.getKey()).multiPartChange(collection);
            }
            int n = MultipartProxy.block().cF;
            for (BlockCoord blockCoord : this.neighborChanges) {
                this.world.g(blockCoord.x, blockCoord.y, blockCoord.z, n);
            }
            finishing = this.parent;
            if (CommandDebug.WIRE_READING) {
                System.out.println("" + this.recalcs + " recalculations");
            }
            this.clear();
        }

        public void start(PropogationRun propogationRun, abw abw2) {
            this.world = abw2;
            this.parent = propogationRun;
            currentRun = this;
            this.runLoop();
        }

        private void runLoop() {
            do {
                LinkedList<Propogation> linkedList = this.propogationList;
                this.propogationList = new LinkedList();
                for (Propogation propogation : linkedList) {
                    propogation.propogate();
                }
                if (!this.propogationList.isEmpty() || this.analogDrops.isEmpty()) continue;
                this.propogationList = this.analogDrops;
                this.analogDrops = new LinkedList();
            } while (!this.propogationList.isEmpty());
            this.finish();
        }

        public void add(IWirePart iWirePart, TMultiPart tMultiPart, int n) {
            if (tMultiPart != this.lastCaller) {
                this.lastCaller = tMultiPart;
                ++this.count;
            }
            this.propogationList.add(new Propogation(iWirePart, tMultiPart, n));
        }

        public void addAnalogDrop(IWirePart iWirePart) {
            this.analogDrops.add(new Propogation(iWirePart, notApart, 0));
        }

        public class Propogation {
            public IWirePart part;
            public TMultiPart prev;
            public int mode;

            public Propogation(IWirePart iWirePart, TMultiPart tMultiPart, int n) {
                this.part = iWirePart;
                this.prev = tMultiPart;
                this.mode = n;
            }

            public void propogate() {
                this.part.updateAndPropogate(this.prev, this.mode);
            }
        }
    }
}

