/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import java.util.Random;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.integration.GatePart;
import mrtjp.projectred.integration.RedstoneGateLogic;
import mrtjp.projectred.integration.RowGatePart;
import mrtjp.projectred.integration.SimpleGatePart;

public abstract class SimpleGateLogic
extends RedstoneGateLogic<SimpleGatePart> {
    public static int[] advanceDead = new int[]{1, 2, 4, 0, 5, 6, 3};
    public static SimpleGateLogic[] instances = new SimpleGateLogic[]{new OR(), new NOR(), new NOT(), new AND(), new NAND(), new XOR(), new XNOR(), new Buffer(), new Multiplexer(), new Pulse(), new Repeater(), new Randomizer(), null, null, new TransparentLatch(), new LightSensor(), new RainSensor(), null, null, null, null, null, null, null, null, null, null, new ANDCell()};

    public static int countBits(int n) {
        int n2 = 0;
        while (n != 0) {
            n &= n - 1;
            ++n2;
        }
        return n2;
    }

    @Override
    public int getOutput(SimpleGatePart simpleGatePart, int n) {
        return (simpleGatePart.state & 16 << n) != 0 ? 15 : 0;
    }

    @Override
    public boolean cycleShape(SimpleGatePart simpleGatePart) {
        int n = simpleGatePart.shape();
        int n2 = this.cycleShape(n);
        if (n2 != n) {
            simpleGatePart.setShape(n2);
            return true;
        }
        return false;
    }

    public int cycleShape(int n) {
        while (SimpleGateLogic.countBits(n = advanceDead[n]) > this.maxDeadSides() && 32 - Integer.numberOfLeadingZeros(n) <= this.maxDeadSides()) {
        }
        return n;
    }

    public int deadSides() {
        return 0;
    }

    public int maxDeadSides() {
        return this.deadSides() - 1;
    }

    public int getDelay(int n) {
        return 2;
    }

    public int feedbackMask(int n) {
        return 0;
    }

    @Override
    public void onChange(SimpleGatePart simpleGatePart) {
        int n;
        int n2 = this.inputMask(simpleGatePart.shape());
        int n3 = this.outputMask(simpleGatePart.shape());
        int n4 = simpleGatePart.state & 0xF;
        int n5 = this.feedbackMask(simpleGatePart.shape());
        int n6 = this.getInput(simpleGatePart, n2 | n5);
        if (n4 != n6) {
            simpleGatePart.setState(simpleGatePart.state & 0xF0 | n6);
            simpleGatePart.onInputChange();
        }
        if ((n = this.calcOutput(simpleGatePart, simpleGatePart.state & n2) & n3) != simpleGatePart.state() >> 4) {
            simpleGatePart.scheduleTick(this.getDelay(simpleGatePart.shape()));
        }
    }

    @Override
    public void scheduledTick(SimpleGatePart simpleGatePart) {
        int n;
        int n2 = this.inputMask(simpleGatePart.shape());
        int n3 = this.outputMask(simpleGatePart.shape());
        int n4 = simpleGatePart.state() >> 4;
        if (n4 != (n = this.calcOutput(simpleGatePart, simpleGatePart.state & n2) & n3)) {
            simpleGatePart.setState(simpleGatePart.state & 0xF | n << 4);
            simpleGatePart.onOutputChange(n3);
        }
        this.onChange(simpleGatePart);
    }

    @Override
    public void setup(SimpleGatePart simpleGatePart) {
        int n = this.inputMask(simpleGatePart.shape());
        int n2 = this.outputMask(simpleGatePart.shape());
        int n3 = this.calcOutput(simpleGatePart, this.getInput(simpleGatePart, n)) & n2;
        if (n3 != 0) {
            simpleGatePart.setState(n3 << 4);
            simpleGatePart.onOutputChange(n3);
        }
    }

    public static class ANDCell
    extends SimpleGateLogic {
        @Override
        public int calcOutput(int n) {
            return n == 14 ? 1 : 0;
        }

        @Override
        public int getInput(SimpleGatePart simpleGatePart, int n) {
            int n2 = super.getInput(simpleGatePart, 4);
            if (((RowGatePart)simpleGatePart).signal != 0) {
                n2 |= 0xA;
            }
            return n2;
        }

        @Override
        public boolean canConnect(int n, int n2) {
            return true;
        }
    }

    public static class RainSensor
    extends SimpleGateLogic {
        @Override
        public int inputMask(int n) {
            return 0;
        }

        @Override
        public int outputMask(int n) {
            return 4;
        }

        @Override
        public int feedbackMask(int n) {
            return 4;
        }

        @Override
        public int cycleShape(int n) {
            return (n + 1) % 5;
        }

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            return simpleGatePart.shape() >> 4;
        }

        @Override
        public void onTick(SimpleGatePart simpleGatePart) {
            int n;
            if (simpleGatePart.world().I) {
                return;
            }
            int n2 = simpleGatePart.world().Q() && simpleGatePart.world().l(simpleGatePart.x(), simpleGatePart.y() + 1, simpleGatePart.z()) ? 4 : 0;
            if (n2 != (n = simpleGatePart.state() >> 4)) {
                simpleGatePart.setState(n2 << 4 | simpleGatePart.state & 0xF);
                simpleGatePart.onOutputChange(4);
            }
        }

        @Override
        public int lightLevel() {
            return 0;
        }
    }

    public static class LightSensor
    extends SimpleGateLogic {
        @Override
        public int getOutput(SimpleGatePart simpleGatePart, int n) {
            return n == 2 ? simpleGatePart.state() >> 4 : 0;
        }

        @Override
        public int inputMask(int n) {
            return 0;
        }

        @Override
        public int outputMask(int n) {
            return 4;
        }

        @Override
        public int feedbackMask(int n) {
            return 4;
        }

        @Override
        public int cycleShape(int n) {
            return (n + 1) % 3;
        }

        @Override
        public void setup(SimpleGatePart simpleGatePart) {
            this.onTick(simpleGatePart);
        }

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            return simpleGatePart.shape() >> 4;
        }

        @Override
        public void onTick(SimpleGatePart simpleGatePart) {
            if (simpleGatePart.world().I) {
                return;
            }
            int n = simpleGatePart.world().b(ach.a, simpleGatePart.x(), simpleGatePart.y(), simpleGatePart.z()) - simpleGatePart.world().j;
            int n2 = simpleGatePart.world().b(ach.b, simpleGatePart.x(), simpleGatePart.y(), simpleGatePart.z());
            int n3 = simpleGatePart.shape();
            int n4 = n3 == 0 ? Math.max(n, n2) : (n3 == 1 ? n : n2);
            if (n4 != simpleGatePart.state() >> 4) {
                simpleGatePart.setState(n4 << 4 | simpleGatePart.state & 0xF);
                simpleGatePart.onOutputChange(4);
            }
        }

        @Override
        public void onChange(SimpleGatePart simpleGatePart) {
            int n = simpleGatePart.state & 0xF;
            int n2 = this.getInput(simpleGatePart, 4);
            if (n != n2) {
                simpleGatePart.setState(simpleGatePart.state & 0xF0 | n2);
                simpleGatePart.onInputChange();
            }
        }

        @Override
        public int lightLevel() {
            return 0;
        }
    }

    public static class TransparentLatch
    extends SimpleGateLogic {
        @Override
        public int cycleShape(int n) {
            return (n + 1) % 2;
        }

        @Override
        public int inputMask(int n) {
            return n == 0 ? 12 : 6;
        }

        @Override
        public int outputMask(int n) {
            return n == 0 ? 3 : 9;
        }

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            if ((n & 4) == 0) {
                return simpleGatePart.state() >> 4;
            }
            return (n & 0xA) == 0 ? 0 : 15;
        }
    }

    public static class Randomizer
    extends SimpleGateLogic {
        public Random rand = new Random();

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            return n == 0 ? simpleGatePart.state() >> 4 : GatePart.shiftMask(this.rand.nextInt(8), 3);
        }

        @Override
        public int outputMask(int n) {
            return 11;
        }

        @Override
        public int feedbackMask(int n) {
            return 11;
        }

        @Override
        public int inputMask(int n) {
            return 4;
        }

        @Override
        public void onChange(SimpleGatePart simpleGatePart) {
            super.onChange(simpleGatePart);
            if ((simpleGatePart.state() & 4) != 0) {
                simpleGatePart.scheduleTick(2);
            }
        }
    }

    public static class Repeater
    extends SimpleGateLogic {
        public int[] delays = new int[]{2, 4, 6, 8, 16, 32, 64, 128, 256};

        @Override
        public int calcOutput(int n) {
            return n == 0 ? 0 : 1;
        }

        @Override
        public int inputMask(int n) {
            return 4;
        }

        @Override
        public void onChange(SimpleGatePart simpleGatePart) {
            if (simpleGatePart.schedTime < 0L) {
                super.onChange(simpleGatePart);
            }
        }

        @Override
        public int getDelay(int n) {
            return this.delays[n];
        }

        @Override
        public int cycleShape(int n) {
            return (n + 1) % this.delays.length;
        }

        @Override
        public boolean activate(SimpleGatePart simpleGatePart, uf uf2, ye ye2) {
            if (ye2 == null || !(ye2.b() instanceof IScrewdriver)) {
                if (!simpleGatePart.world().I) {
                    simpleGatePart.configure();
                }
                return true;
            }
            return false;
        }
    }

    public static class Pulse
    extends SimpleGateLogic {
        @Override
        public int calcOutput(int n) {
            return 0;
        }

        @Override
        public int inputMask(int n) {
            return 4;
        }

        @Override
        public void onChange(SimpleGatePart simpleGatePart) {
            int n = simpleGatePart.state & 0xF;
            int n2 = this.getInput(simpleGatePart, 4);
            if (n != n2) {
                simpleGatePart.setState(simpleGatePart.state & 0xF0 | n2);
                simpleGatePart.onInputChange();
                if (n2 != 0 && (simpleGatePart.state & 0xF0) == 0) {
                    simpleGatePart.setState(simpleGatePart.state & 0xF | 0x10);
                    simpleGatePart.scheduleTick(2);
                    simpleGatePart.onOutputChange(1);
                }
            }
        }
    }

    public static class Multiplexer
    extends SimpleGateLogic {
        @Override
        public int outputMask(int n) {
            return 1;
        }

        @Override
        public int inputMask(int n) {
            return 14;
        }

        @Override
        public int calcOutput(int n) {
            boolean bl;
            boolean bl2 = (n & 2) != 0;
            boolean bl3 = (n & 4) != 0;
            boolean bl4 = bl = (n & 8) != 0;
            return bl3 ? (bl ? 1 : 0) : (bl2 ? 1 : 0);
        }
    }

    public static class Buffer
    extends SimpleGateLogic {
        @Override
        public int feedbackMask(int n) {
            return this.outputMask(n);
        }

        @Override
        public int outputMask(int n) {
            int n2 = 0;
            n2 |= (n & 1) << 1;
            n2 |= (n & 2) << 2;
            return ~(n2 |= (n & 8) << 4) & 0xB;
        }

        @Override
        public int inputMask(int n) {
            return 4;
        }

        @Override
        public int deadSides() {
            return 2;
        }

        @Override
        public int calcOutput(int n) {
            return n != 0 ? 11 : 0;
        }
    }

    public static class XNOR
    extends SimpleGateLogic {
        @Override
        public int inputMask(int n) {
            int n2 = 0;
            n2 |= 2;
            return n2 |= 8;
        }

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            boolean bl = (n & 2) != 0;
            boolean bl2 = (n & 8) != 0;
            return bl == bl2 ? 1 : 0;
        }
    }

    public static class XOR
    extends SimpleGateLogic {
        @Override
        public int inputMask(int n) {
            int n2 = 0;
            n2 |= 2;
            return n2 |= 8;
        }

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            boolean bl = (n & 2) != 0;
            boolean bl2 = (n & 8) != 0;
            return bl != bl2 ? 1 : 0;
        }
    }

    public static class NAND
    extends SimpleGateLogic {
        @Override
        public int inputMask(int n) {
            return ~n << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            return n == this.inputMask(simpleGatePart.shape()) ? 0 : 1;
        }
    }

    public static class AND
    extends SimpleGateLogic {
        @Override
        public int inputMask(int n) {
            return ~n << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(SimpleGatePart simpleGatePart, int n) {
            return n == this.inputMask(simpleGatePart.shape()) ? 1 : 0;
        }
    }

    public static class NOT
    extends SimpleGateLogic {
        @Override
        public int feedbackMask(int n) {
            return this.outputMask(n);
        }

        @Override
        public int outputMask(int n) {
            int n2 = 0;
            n2 |= (n & 1) << 1;
            n2 |= (n & 2) >> 1;
            return ~(n2 |= (n & 4) << 1) & 0xB;
        }

        @Override
        public int inputMask(int n) {
            return 4;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(int n) {
            return n == 0 ? 11 : 0;
        }
    }

    public static class NOR
    extends SimpleGateLogic {
        @Override
        public int feedbackMask(int n) {
            return 1;
        }

        @Override
        public int inputMask(int n) {
            return ~n << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(int n) {
            return n == 0 ? 1 : 0;
        }
    }

    public static class OR
    extends SimpleGateLogic {
        @Override
        public int inputMask(int n) {
            return ~n << 1 & 0xE;
        }

        @Override
        public int deadSides() {
            return 3;
        }

        @Override
        public int calcOutput(int n) {
            return n != 0 ? 1 : 0;
        }
    }
}

