/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.integration.GatePart;

public class ArrayCommons {
    public static Cuboid6[][] oBoxes = new Cuboid6[6][2];
    public static Cuboid6[] cBoxes = new Cuboid6[6];

    public static byte topWireConn(GatePart gatePart) {
        byte by2 = 0;
        for (int i = 1; i < 4; i += 2) {
            if (!ArrayCommons.topWireConn(gatePart, gatePart.toAbsolute(i))) continue;
            by2 = (byte)(by2 | 1 << i);
        }
        return by2;
    }

    private static boolean topWireConn(GatePart gatePart, int n) {
        TMultiPart tMultiPart;
        int n2 = Rotation.rotateSide((int)gatePart.side(), (int)n);
        BlockCoord blockCoord = new BlockCoord((asp)gatePart.tile()).offset(n2);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)gatePart.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap(gatePart.side())) instanceof ITopArrayWire) {
            int n3 = ((GatePart)tMultiPart).rotation();
            return (n3 & 1) == (gatePart.rotation() & 1);
        }
        return false;
    }

    static {
        ArrayCommons.oBoxes[0][0] = new Cuboid6(0.125, 0.0, 0.0, 0.875, 0.75, 1.0);
        ArrayCommons.oBoxes[0][1] = new Cuboid6(0.0, 0.0, 0.125, 1.0, 0.75, 0.875);
        ArrayCommons.cBoxes[0] = new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
        for (int i = 1; i < 6; ++i) {
            Transformation transformation = Rotation.sideRotations[i].at(Vector3.center);
            ArrayCommons.oBoxes[i][0] = oBoxes[0][0].copy().apply(transformation);
            ArrayCommons.oBoxes[i][1] = oBoxes[0][1].copy().apply(transformation);
            ArrayCommons.cBoxes[i] = cBoxes[0].copy().apply(transformation);
        }
    }

    public static interface ITopArrayWire {
    }
}

